<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\District;
use App\Models\Subcategory;

class DistrictController extends Controller
{
    
     public function AllDistrict(){

        $districts = District::with('division')->latest()->get();
        return view('backend.district.district_all',compact('districts'));

    } // End Mehtod 

    public function AddDistrict(){

        $subcategories = Subcategory::orderBy('id', 'ASC')->limit(8)->get();
        return view('backend.district.district_add',compact('subcategories'));

    } 

     public function StoreDistrict(Request $request){

        District::insert([
            'division_id' => $request->division_id,
            'name' => $request->name,
            'slug' => strtolower(str_replace(' ', '-', $request->name)),

        ]); 


         $notification = array(
            'message' => 'District Inserted Successfully',
            'alert-type' => 'success'

        );

        return redirect()->route('all.district')->with($notification);


    }// End Mehtod 


    public function EditDistrict($id){

        $subcategories = Subcategory::orderBy('id', 'ASC')->limit(8)->get();
        $district = District::findOrFail($id);
        return view('backend.district.district_edit',compact('district','subcategories'));
    }// End Mehtod


 public function UpdateDistrict(Request $request){

       $subcat_id = $request->id;

       District::findOrFail($subcat_id)->update([
            'division_id' => $request->division_id,
            'name' => $request->name,
            'slug' => strtolower(str_replace(' ', '-', $request->name)),

        ]); 


         $notification = array(
            'message' => 'District Updated Successfully',
            'alert-type' => 'success'

        );

        return redirect()->route('all.district')->with($notification);


    }// End Mehtod 

     public function DeleteDistrict($id){

        District::findOrFail($id)->delete();

         $notification = array(
            'message' => 'District Deleted Successfully',
            'alert-type' => 'success'

        );

        return redirect()->back()->with($notification);

    }// End Mehtod 

 
    public function GetDistrict($division_id){

        $subcat = District::where('division_id',$division_id)->orderBy('name','ASC')->get();
            return json_encode($subcat);

    }// End Mehtod 

}
 