<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Subcategory;
use App\Models\User;
use App\Models\NewsPost;
use App\Models\PhotoGallery;
use Carbon\Carbon; 
use App\Models\Thana;
use App\Models\UpozilaThana;

use App\Models\District;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Validator;
use Auth;


class NewsPostController extends Controller 
{
    // public function AllNewsPost(){
    //     // dd(Auth::user()->id);
    //     // $allnews = NewsPost::latest()->paginate(25);
    //     $allEdittornews = NewsPost::where('user_id', Auth::user()->id)->latest()->get();
    //     // dd($allnews->toArray());
        
    // //   $allnews = NewsPost::where(function($query){
    // //                 $query->whereNull('status_option')   
    // //                       ->orWhere('status_option', '!=', 2); 
    // //             })
    // //             ->latest()
    // //             ->get();
    
    //   $allnews = NewsPost::where(function($query){
    //                     $query->whereNull('status_option')
    //                           ->orWhere('status_option', '!=', 2);
    //                 })
    //                 ->when($user->role == 'editor', function ($query) use ($user) {
    //                     // Editor: show only own posts
    //                     $query->where('user_id', $user->id);
    //                 })
    //                 // Admin (or any other role) sees all news
    //                 ->latest()
    //                 ->get();
                
                
    //     return view('backend.news.all_news_post',compact('allnews', 'allEdittornews'));
    // } 
    
    
    
    public function AllNewsPost()
{
    $user = Auth::user();

    // Common condition
    $baseQuery = NewsPost::where(function($query){
                        $query->whereNull('status_option')
                              ->orWhere('status_option', '!=', 2);
                    });

    // Admin → all news
    $allnews = $baseQuery->latest()->get();

    // Editor → only his own news
    $allEdittornews = $baseQuery->where('user_id', $user->id)
                                ->latest()
                                ->get();

    return view('backend.news.all_news_post', compact('allnews', 'allEdittornews'));
}




    // public function AllDraftNewsPost(){
    //     // dd(Auth::user()->id);
    //     // $allnews = NewsPost::where('status_option', 2)->paginate(25);
    //     $allnews = NewsPost::where('status_option', 2)->get();
    //     // $allEdittornews = NewsPost::where('user_id', Auth::user()->id)->latest()->get();
        
    //     return view('backend.news.draft_news',compact('allnews'));
    // } // End Method
    
    
      public function AllDraftNewsPost(){
        
        // $allnews = NewsPost::where('status_option', 2)->get();
        
         $user = Auth::user();

    // Common condition
    $baseQuery = NewsPost::where(function($query){
                        $query->orWhere('status_option', 2);
                    });

    // Admin → all news
    $allnews = $baseQuery->latest()->get();

    // Editor → only his own news
    $allEdittornews = $baseQuery->where('user_id', $user->id)
                                ->latest()
                                ->get();
        
        
        return view('backend.news.draft_news',compact('allnews', 'allEdittornews'));
    } 



    // public function AddNewsPost(){
         
    //      $categories = Category::latest()->get();
    //      $subcategories = Subcategory::latest()->get();
    //      $adminuser = User::where('role','admin')->latest()->get();
         
    //     return view('backend.news.add_news_post',compact('categories','subcategories','adminuser'));
    // }
    
    
    
public function AddNewsPost()
{
    $categories = Category::latest()->get();
    $subcategories = Subcategory::latest()->get();
    $adminuser = User::where('role','admin')->latest()->get();

    // Fetch Gallery Photos
    $galleryPhotos = PhotoGallery::select('id', 'photo_gallery', 'title', 'created_at')
        ->get()
        ->map(function ($item) {
            return [
                'id' => $item->id,
                'image' => $item->photo_gallery,
                'type' => 'gallery',
                'name' => $item->title,
                'created_at' => $item->created_at
            ];
        });

    // Fetch News Photos
    $newsPhotos = NewsPost::where('status', 1)
        ->select('id', 'image', 'img_title', 'created_at')
        ->get()
        ->map(function ($item) {
            return [
                'id' => $item->id,
                'image' => $item->image,
                'type' => 'news',
                'name' => $item->img_title,
                'created_at' => $item->created_at
            ];
        });

    // Merge both collections and sort by created_at (latest first)
    $allPhotos = $galleryPhotos
                    ->merge($newsPhotos)
                    ->sortByDesc('created_at')
                    ->values();

    // Pass everything to the view
    return view('backend.news.add_news_post', compact(
        'categories',
        'subcategories',
        'adminuser',
        'allPhotos' // ← all images
    ));
}

    
    
    
    


    // public function StoreNewsPost(Request $request){


    //     $request->validate([
    //         // 'news_title' => 'required',
    //         'category_id' => 'required',
    //         'news_details' => 'required',
    //         'image' => 'required',
    //         'user_id' => 'required',
    //     ]);
            
    //     $image = $request->file('image');
    //     $name_gen = hexdec(uniqid()).'.'.$image->getClientOriginalExtension();
    //     Image::make($image)->resize(750,450)->save('upload/news/'.$name_gen);
    //     $save_url = 'upload/news/'.$name_gen;
        
        
     
        
    //     if ($request->hasFile('pdf_file')) {
    //         $pdf = $request->file('pdf_file');
    //         $name_pdf = hexdec(uniqid()).'.'.$pdf->getClientOriginalExtension();
    //         $pdf->move(public_path('upload/news/pdf'), $name_pdf);
    //         $save_url_pdf = 'upload/news/pdf/'.$name_pdf;
    //     } else {
    //         $save_url_pdf = null; // or handle as needed
    //     }




    //     NewsPost::insert([

    //         'category_id' => $request->category_id,
    //         'subcategory_id' => $request->subcategory_id,
    //         'district_id' => $request->district_id,
    //         'thana_id' => $request->thana_id,
    //         'user_id' => $request->user_id,
    //         'news_title' => $request->news_title,
    //         'news_shoulder' => $request->news_shoulder,
    //         'meta_desc' => $request->meta_desc,
    //         'img_title' => $request->img_title,
    //         'meta_keywords' => $request->meta_keywords,
    //         'news_hanger' => $request->news_hanger,
    //         'news_title_slug' => strtolower(str_replace(' ','-',$request->news_title)),

    //         'news_details' => $request->news_details,
    //         'tags' => $request->tags,

    //         'breaking_news' => $request->breaking_news,
    //         'top_slider' => $request->top_slider,
    //         'first_section_three' => $request->first_section_three,
    //         'first_section_nine' => $request->first_section_nine,
            
    //         'sukhobor' => $request->sukhobor,
    //         'alocito' => $request->alocito,
    //         'jatiyo' => $request->jatiyo,
    //         'status_option' => $request->status_option,
            

    //         'post_date' => date('d-m-Y'),
    //         'post_month' => date('F'),
    //         'image' => $save_url,
    //         'created_at' => Carbon::now(),
    //         'updated_at' => Carbon::now('Asia/Dhaka'),  
            
    //         'pdf_title' => $request->pdf_title,
    //         'pdf_file' => $save_url_pdf,   

    //     ]);

    //      $notification = array(
    //         'message' => 'News Post Inserted Successfully',
    //         'alert-type' => 'success'

    //     );
    //     return redirect()->route('all.news.post')->with($notification);


    // }
    
    
    
//     public function StoreNewsPost(Request $request){

//     $request->validate([
//         'category_id' => 'required',
//         'news_details' => 'required',
//         'user_id' => 'required',
//         'image' => 'required',
//     ]);

//     // ------------------------
//     // Image Handling
//     // ------------------------

//     // MEDIA URL (not a file)
//     if (!$request->hasFile('image') && $request->image) {
//         $save_url = $request->image;
//     }

//     // FILE UPLOAD
//     elseif ($request->hasFile('image')) {

//         $image = $request->file('image');

//         $name_gen = hexdec(uniqid()).'.'.$image->getClientOriginalExtension();
//         Image::make($image)->resize(750,450)->save('upload/news/'.$name_gen);
//         $save_url = 'upload/news/'.$name_gen;
//     }

//     else {
//         return back()->with('error', 'Image is required.');
//     }

//     // ------------------------
//     // PDF Handling
//     // ------------------------
//     if ($request->hasFile('pdf_file')) {
//         $pdf = $request->file('pdf_file');
//         $name_pdf = hexdec(uniqid()).'.'.$pdf->getClientOriginalExtension();
//         $pdf->move(public_path('upload/news/pdf'), $name_pdf);
//         $save_url_pdf = 'upload/news/pdf/'.$name_pdf;
//     } else {
//         $save_url_pdf = null;
//     }

//     // ------------------------
//     // Insert News
//     // ------------------------

//     NewsPost::insert([
//         'category_id' => $request->category_id,
//         'subcategory_id' => $request->subcategory_id,
//         'district_id' => $request->district_id,
//         'thana_id' => $request->thana_id,
//         'user_id' => $request->user_id,

//         'news_title' => $request->news_title,
//         'news_shoulder' => $request->news_shoulder,
//         'meta_desc' => $request->meta_desc,
//         'img_title' => $request->img_title,
//         'meta_keywords' => $request->meta_keywords,
//         'news_hanger' => $request->news_hanger,
//         'news_title_slug' => strtolower(str_replace(' ','-',$request->news_title)),

//         'news_details' => $request->news_details,
//         'tags' => $request->tags,

//         'breaking_news' => $request->breaking_news,
//         'top_slider' => $request->top_slider,
//         'first_section_three' => $request->first_section_three,
//         'first_section_nine' => $request->first_section_nine,

//         'sukhobor' => $request->sukhobor,
//         'alocito' => $request->alocito,
//         'jatiyo' => $request->jatiyo,
//         'status_option' => $request->status_option,

//         'post_date' => date('d-m-Y'),
//         'post_month' => date('F'),
//         'image' => $save_url,
//         'created_at' => Carbon::now(),
//         'updated_at' => Carbon::now('Asia/Dhaka'),

//         'pdf_title' => $request->pdf_title,
//         'pdf_file' => $save_url_pdf,
//     ]);

//     return redirect()->route('all.news.post')->with([
//         'message' => 'News Post Inserted Successfully',
//         'alert-type' => 'success'
//     ]);
// }





public function StoreNewsPost(Request $request)
{
    $request->validate([
        'category_id' => 'required',
        'news_details' => 'required',
        'user_id' => 'required',
        'image' => 'required',
    ]);
    
    // $lastPos = NewsPost::max('position') + 1;

    // ------------------------
    // Image Handling
    // ------------------------
    $save_url = null;

    // Case 1: User selected a media URL (from gallery)
    if ($request->image && ! $request->hasFile('image')) {

        // Check if the input is Base64 (Desktop Upload)
        if (preg_match('/^data:image\/(\w+);base64,/', $request->image, $type)) {
            $data = substr($request->image, strpos($request->image, ',') + 1);
            $data = base64_decode($data);
            $extension = strtolower($type[1]); // jpg, png, etc.
            $fileName = hexdec(uniqid()) . '.' . $extension;
            $filePath = 'upload/news/' . $fileName;
            file_put_contents($filePath, $data);
            $save_url = $filePath;
        } else {
            // It's a normal media URL
            $save_url = $request->image;
        }

    }
    // Case 2: User uploaded a file
    elseif ($request->hasFile('image')) {
        $image = $request->file('image');
        $name_gen = hexdec(uniqid()) . '.' . $image->getClientOriginalExtension();
        \Image::make($image)->save('upload/news/' . $name_gen);
        $save_url = 'upload/news/' . $name_gen;
    }
    // Case 3: No image provided
    else {
        return back()->with('error', 'Image is required.');
    }

    // ------------------------
    // PDF Handling
    // ------------------------
    if ($request->hasFile('pdf_file')) {
        $pdf = $request->file('pdf_file');
        $name_pdf = hexdec(uniqid()) . '.' . $pdf->getClientOriginalExtension();
        $pdf->move(public_path('upload/news/pdf'), $name_pdf);
        $save_url_pdf = 'upload/news/pdf/' . $name_pdf;
    } else {
        $save_url_pdf = null;
    }
    
    
    
    \App\Models\NewsPost::increment('position');
    
    
    
    $status = $request->status_option;

    if ($status == 3 && $request->publish_date) {
        if (Carbon::parse($request->publish_date)->gt(Carbon::now('Asia/Dhaka'))) {
            $status = 3; // future date
        } else {
            $status = 1; // past date
        }
    }



    $createdAt = $request->publish_date
        ? Carbon::parse($request->publish_date, 'Asia/Dhaka')
        : Carbon::now('Asia/Dhaka');

    // ------------------------
    // Insert News
    // ------------------------
    \App\Models\NewsPost::insert([
        'category_id' => $request->category_id,
        'subcategory_id' => $request->subcategory_id,
        'district_id' => $request->district_id,
        'thana_id' => $request->thana_id,
        'upozila_thana_id' => $request->upozila_thana_id,
        
        
        
        'user_id' => $request->user_id,
        'reporter' => $request->reporter,

        'news_title' => $request->news_title,
        'news_shoulder' => $request->news_shoulder,  
        'meta_desc' => $request->meta_desc,   
        'img_title' => $request->img_title,
        'meta_keywords' => $request->meta_keywords,
        'news_hanger' => $request->news_hanger,
        'news_title_slug' => strtolower(str_replace(' ', '-', $request->news_title)),

        'news_details' => $request->news_details,
        'tags' => $request->tags_desktop ?? $request->tags_mobile,

        'breaking_news' => $request->breaking_news,
        'top_slider' => $request->top_slider,
        'first_section_three' => $request->first_section_three,
        'first_section_nine' => $request->first_section_nine,

        'sukhobor' => $request->sukhobor,
        'alocito' => $request->alocito,
        'jatiyo' => $request->jatiyo,
        'top_news' => $request->top_news,
        'status_option' => $status,
        'position' =>  1,
        'publish_date' => $request->publish_date,
        

        'post_date' => date('d-m-Y'),
        'post_month' => date('F'),
        'image' => $save_url,
        'created_at' => $createdAt,
        'updated_at' => \Carbon\Carbon::now('Asia/Dhaka'),

        'pdf_title' => $request->pdf_title,
        'pdf_file' => $save_url_pdf,
    ]);

    return redirect()->route('all.news.post')->with([
        'message' => 'News Post Inserted Successfully',
        'alert-type' => 'success'
    ]);
}








    public function EditNewsPost($id){

         $categories = Category::latest()->get();
         $subcategories = Subcategory::latest()->get();
         $adminuser = User::where('role','admin')->latest()->get();
         $newspost = NewsPost::findOrFail($id);
         $district = [];
         if($newspost->district_id){
            $district = District::findOrFail($newspost->district_id);
         }
         $subcats = [];
         if($newspost->subcategory_id){
            $subcats = Subcategory::findOrFail($newspost->subcategory_id);
         }
         $thana = [];
         if($newspost->thana_id){
            $thana = Thana::findOrFail($newspost->thana_id);
         }
         
         $upozilaThana = [];
         if($newspost->upozila_thana_id){
            $upozilaThana = UpozilaThana::findOrFail($newspost->upozila_thana_id);
         }
         
         return view('backend.news.edit_news_post',compact('categories','district','subcats','thana','subcategories','adminuser','newspost', 'upozilaThana'));
    }// End Method
    
    
    
    
    

    // public function UpdateNewsPost(Request $request){

    //     // dd($request->all());
        
    //     $request->validate([
    //         'news_title' => 'required',
    //         'category_id' => 'required',
    //         'news_details' => 'required',
    //         'user_id' => 'required',
    //     ]);
        
    //     $newspost_id = $request->id;

    //     if ($request->file('image')) {

    //     $image = $request->file('image');
    //     $name_gen = hexdec(uniqid()).'.'.$image->getClientOriginalExtension();
    //     Image::make($image)->resize(750,450)->save('upload/news/'.$name_gen);
    //     $save_url = 'upload/news/'.$name_gen;
        
        
    //     if ($request->hasFile('pdf_file')) {
    //         $pdf = $request->file('pdf_file');
    //         $name_pdf = hexdec(uniqid()).'.'.$pdf->getClientOriginalExtension();
    //         $pdf->move(public_path('upload/news/pdf'), $name_pdf);
    //         $save_url_pdf = 'upload/news/pdf/'.$name_pdf;
            
    //     }
        
       
        


    //     NewsPost::findOrFail($newspost_id)->update([
            
    //         'category_id' => $request->category_id,
    //         'subcategory_id' => $request->subcategory_id,
    //         'district_id' => $request->district_id,
    //         'thana_id' => $request->thana_id,
    //         'user_id' => $request->user_id,
    //         'news_title' => $request->news_title,
    //         'img_title' => $request->img_title,
    //         'news_shoulder' => $request->news_shoulder,
    //         'news_hanger' => $request->news_hanger,
    //         'meta_desc' => $request->meta_desc,
    //         'meta_keywords' => $request->meta_keywords,
    //         'news_title_slug' => strtolower(str_replace(' ','-',$request->news_title)),

    //         'news_details' => $request->news_details,
    //         'tags' => $request->tags,

    //         'breaking_news' => $request->breaking_news,
    //         'top_slider' => $request->top_slider,
    //         'first_section_three' => $request->first_section_three,
    //         'first_section_nine' => $request->first_section_nine,
            
    //         'sukhobor' => $request->sukhobor,
    //         'alocito' => $request->alocito,
    //         'status_option' => $request->status_option,

    //         'post_date' => date('d-m-Y'),
    //         'post_month' => date('F'),
    //         'image' => $save_url,
    //         'updated_at' => Carbon::now('Asia/Dhaka'),  
            
    //         'pdf_title' => $request->pdf_title,
    //         'pdf_file' => $save_url_pdf,
            
            

    //     ]);

    //      $notification = array(
    //         'message' => 'News Post Updated with Image Successfully',
    //         'alert-type' => 'success'

    //     );
        
    //     // return redirect()->route('all.news.post')->with($notification);
        
    //     return redirect()->back()->with($notification);


    //     }else{
            
    //         $upnews = NewsPost::find($newspost_id);
            
    //         $upnews->category_id = $request->category_id;
    //         $upnews->subcategory_id = $request->subcategory_id;
    //         $upnews->user_id = $request->user_id;
    //         $upnews->news_title = $request->news_title;
    //         $upnews->news_shoulder = $request->news_shoulder;
    //         $upnews->img_title = $request->img_title;
    //         $upnews->news_hanger = $request->news_hanger;
    //         $upnews->news_title_slug = strtolower(str_replace(' ','-',$request->news_title));
    //         $upnews->news_details = $request->news_details;
    //         $upnews->tags = $request->tags;
    //         $upnews->breaking_news = $request->breaking_news;
    //         $upnews->top_slider = $request->top_slider;
    //         $upnews->first_section_three = $request->first_section_three;
    //         $upnews->first_section_nine = $request->first_section_nine;
    //         $upnews->sukhobor = $request->sukhobor;
    //         $upnews->alocito = $request->alocito;
    //         $upnews->status_option = $request->status_option;
    //         $upnews->post_date = date('d-m-Y');
    //         $upnews->post_month = date('F');
    //         $upnews->updated_at = Carbon::now('Asia/Dhaka');
    //         $upnews->pdf_title = $request->pdf_title;
            
    //         if ($request->hasFile('pdf_file')) {
    //             $pdf = $request->file('pdf_file');
    //             $name_pdf = hexdec(uniqid()).'.'.$pdf->getClientOriginalExtension();
    //             $pdf->move(public_path('upload/news/pdf'), $name_pdf);
    //             $upnews->pdf_file = 'upload/news/pdf/'.$name_pdf;
                
    //         }
        
        
    //      if ($request->delete_pdf == 1 && !empty($upnews->pdf_file)) {
    //         if (file_exists(public_path($upnews->pdf_file))) {
    //             unlink(public_path($upnews->pdf_file)); // delete the file
    //         }
    //         $upnews->pdf_file = null; // remove reference in database
    //         $upnews->pdf_title = null; // optional: also remove the title
    //     }
        
        
        
    //         $upnews->save();

           

    //      $notification = array(
    //         'message' => 'News Post Updated without Image Successfully',
    //         'alert-type' => 'success'

    //     );
        
    //     // return redirect()->route('all.news.post')->with($notification);
        
    //      return redirect()->back()->with($notification);

    //     } 

    // }
    
    
    
    
    
    
//     public function UpdateNewsPost(Request $request) {
//     $request->validate([
//         'news_title' => 'required',
//         'category_id' => 'required',
//         'news_details' => 'required',
//         'user_id' => 'required',
//     ]);

//     $upnews = NewsPost::findOrFail($request->id);

//     // Handle image upload
//     if ($request->hasFile('image')) {
//         // delete old image if exists
//         if (!empty($upnews->image) && file_exists(public_path($upnews->image))) {
//             unlink(public_path($upnews->image));
//         }

//         $image = $request->file('image');
//         $name_gen = hexdec(uniqid()).'.'.$image->getClientOriginalExtension();
//         Image::make($image)->resize(750,450)->save('upload/news/'.$name_gen);
//         $upnews->image = 'upload/news/'.$name_gen;
//     }

//     // Handle PDF upload
//     if ($request->hasFile('pdf_file')) {
//         if (!empty($upnews->pdf_file) && file_exists(public_path($upnews->pdf_file))) {
//             unlink(public_path($upnews->pdf_file));
//         }
//         $pdf = $request->file('pdf_file');
//         $name_pdf = hexdec(uniqid()).'.'.$pdf->getClientOriginalExtension();
//         $pdf->move(public_path('upload/news/pdf'), $name_pdf);
//         $upnews->pdf_file = 'upload/news/pdf/'.$name_pdf;
//         $upnews->pdf_title = $request->pdf_title;
//     }
//     // Handle PDF delete checkbox
//     elseif ($request->delete_pdf == 1 && !empty($upnews->pdf_file)) {
//         if (file_exists(public_path($upnews->pdf_file))) {
//             unlink(public_path($upnews->pdf_file));
//         }
//         $upnews->pdf_file = null;
//         $upnews->pdf_title = null;
//     }
//     else {
//         // if no new PDF, keep title updated
//         $upnews->pdf_title = $request->pdf_title;
//     }

//     // Update other fields
//     $upnews->category_id = $request->category_id;
//     $upnews->subcategory_id = $request->subcategory_id;
//     $upnews->district_id = $request->district_id;
//     $upnews->thana_id = $request->thana_id;
//     $upnews->user_id = $request->user_id;
//     $upnews->news_title = $request->news_title;
//     $upnews->img_title = $request->img_title;
//     $upnews->news_shoulder = $request->news_shoulder;
//     $upnews->news_hanger = $request->news_hanger;
//     $upnews->news_title_slug = strtolower(str_replace(' ','-',$request->news_title));
//     $upnews->news_details = $request->news_details;
//     $upnews->tags = $request->tags;
//     $upnews->breaking_news = $request->breaking_news ?? 0;
//     $upnews->top_slider = $request->top_slider ?? 0;
//     $upnews->first_section_three = $request->first_section_three ?? 0;
//     $upnews->first_section_nine = $request->first_section_nine ?? 0;
//     $upnews->sukhobor = $request->sukhobor ?? 0;
//     $upnews->alocito = $request->alocito ?? 0;
//     $upnews->jatiyo = $request->jatiyo ?? 0;
//     $upnews->status_option = $request->status_option;
//     $upnews->meta_desc = $request->meta_desc;
//     $upnews->meta_keywords = $request->meta_keywords;
//     $upnews->post_date = date('d-m-Y');
//     $upnews->post_month = date('F');
//     $upnews->updated_at = Carbon::now('Asia/Dhaka');

//     $upnews->save();

//     $notification = [
//         'message' => 'News Post Updated Successfully',
//         'alert-type' => 'success'
//     ];

//     return redirect()->back()->with($notification);
// }
    
    
    
//  public function UpdateNewsPost(Request $request) 
// {
//     $request->validate([
//         'news_title'   => 'required',
//         'category_id'  => 'required',
//         'news_details' => 'required',
//         'user_id'      => 'required',
//     ]);

//     $upnews = NewsPost::findOrFail($request->id);

//     /* ---------------------------------------
//       IMAGE UPLOAD
//     ----------------------------------------*/
//     if ($request->hasFile('image')) {

//         // Delete old image
//         if (!empty($upnews->image) && file_exists(public_path($upnews->image))) {
//             @unlink(public_path($upnews->image));
//         }

//         $image = $request->file('image');
//         $name_gen = hexdec(uniqid()) . '.' . $image->getClientOriginalExtension();

//         $path = public_path('upload/news');
//         if (!file_exists($path)) {
//             mkdir($path, 0777, true);
//         }

//         Image::make($image)->resize(750,450)->save($path . '/' . $name_gen);
//         $upnews->image = 'upload/news/' . $name_gen;
//     }

//     /* ---------------------------------------
//       PDF UPLOAD
//     ----------------------------------------*/
//     if ($request->hasFile('pdf_file')) {

//         if (!empty($upnews->pdf_file) && file_exists(public_path($upnews->pdf_file))) {
//             @unlink(public_path($upnews->pdf_file));
//         }

//         $pdf = $request->file('pdf_file');
//         $name_pdf = hexdec(uniqid()) . '.' . $pdf->getClientOriginalExtension();

//         $pdf->move(public_path('upload/news/pdf'), $name_pdf);
//         $upnews->pdf_file = 'upload/news/pdf/' . $name_pdf;
//         $upnews->pdf_title = $request->pdf_title;
//     }
//     elseif ($request->delete_pdf == 1 && !empty($upnews->pdf_file)) {

//         if (file_exists(public_path($upnews->pdf_file))) {
//             @unlink(public_path($upnews->pdf_file));
//         }

//         $upnews->pdf_file = null;
//         $upnews->pdf_title = null;
//     }
//     else {
//         // Update title if PDF exists but is not replaced
//         $upnews->pdf_title = $request->pdf_title;
//     }

//     /* ---------------------------------------
//       OTHER FIELDS
//     ----------------------------------------*/
//     $upnews->category_id = $request->category_id;
//     $upnews->subcategory_id = $request->subcategory_id;
//     $upnews->district_id = $request->district_id;
//     $upnews->thana_id = $request->thana_id;
//     $upnews->user_id = $request->user_id;

//     $upnews->news_title = $request->news_title;
//     $upnews->news_title_slug = strtolower(str_replace(' ','-',$request->news_title));

//     $upnews->img_title = $request->img_title;
//     $upnews->news_shoulder = $request->news_shoulder;
//     $upnews->news_hanger = $request->news_hanger;
//     $upnews->news_details = $request->news_details;

//     $upnews->tags = $request->tags;

//     // Boolean fields
//     $upnews->breaking_news = $request->breaking_news ?? 0;
//     $upnews->top_slider = $request->top_slider ?? 0;
//     $upnews->first_section_three = $request->first_section_three ?? 0;
//     $upnews->first_section_nine = $request->first_section_nine ?? 0;
//     $upnews->sukhobor = $request->sukhobor ?? 0;
//     $upnews->alocito = $request->alocito ?? 0;
//     $upnews->jatiyo = $request->jatiyo ?? 0;

//     $upnews->status_option = $request->status_option;

//     $upnews->meta_desc = $request->meta_desc;
//     $upnews->meta_keywords = $request->meta_keywords;

//     $upnews->post_date = date('d-m-Y');
//     $upnews->post_month = date('F');
//     $upnews->updated_at = Carbon::now('Asia/Dhaka');

//     $upnews->save();

//     return redirect()->back()->with([
//         'message' => 'News Post Updated Successfully',
//         'alert-type' => 'success'
//     ]);
// }




public function UpdateNewsPost(Request $request)
{
    // Basic validation
    $request->validate([
        'news_title'   => 'required',
        'category_id'  => 'required',
        'news_details' => 'required',
        'user_id'      => 'required',
    ]);

    // Make sure id exists
    $upnews = NewsPost::findOrFail($request->id);

    // ------------------------
    // IMAGE HANDLING (file | base64 | media URL)
    // ------------------------
    $save_url = $upnews->image; // default keep old

    // Case A: user provided an "image" string but not a file (media URL or base64)
    if ($request->image && ! $request->hasFile('image')) {

        // If base64 data
        if (preg_match('/^data:image\/(\w+);base64,/', $request->image, $type)) {

            // delete old image if exists
            if (!empty($upnews->image) && file_exists(public_path($upnews->image))) {
                @unlink(public_path($upnews->image));
            }

            $data = substr($request->image, strpos($request->image, ',') + 1);
            $data = base64_decode($data);
            $extension = strtolower($type[1]); // jpg, png, etc.
            $fileName = hexdec(uniqid()) . '.' . $extension;

            // ensure directory
            $dir = public_path('upload/news');
            if (!file_exists($dir)) {
                mkdir($dir, 0755, true);
            }

            $filePath = 'upload/news/' . $fileName;
            file_put_contents(public_path($filePath), $data);

            $save_url = $filePath;
        } else {
            // Normal media URL (e.g. 'upload/news/xxx.jpg' or external URL)
            // If you want to just accept internal URLs, you can validate here.
            // If it's an external URL and you want to download it, do that explicitly.
            $save_url = $request->image;
        }
    }
    // Case B: file uploaded via input[name="image"]
    elseif ($request->hasFile('image')) {

        // delete old image if exists
        if (!empty($upnews->image) && file_exists(public_path($upnews->image))) {
            @unlink(public_path($upnews->image));
        }

        $image = $request->file('image');
        $name_gen = hexdec(uniqid()) . '.' . $image->getClientOriginalExtension();

        $dir = public_path('upload/news');
        if (!file_exists($dir)) {
            mkdir($dir, 0755, true);
        }

        // Resize & save (Intervention Image)
        Image::make($image)->save($dir . '/' . $name_gen);

        $save_url = 'upload/news/' . $name_gen;
    }
    // else: keep existing image ($save_url is already set)

    // ------------------------
    // PDF HANDLING (upload / keep / delete)
    // ------------------------
    $save_url_pdf = $upnews->pdf_file; // default keep

    if ($request->hasFile('pdf_file')) {
        // delete old pdf
        if (!empty($upnews->pdf_file) && file_exists(public_path($upnews->pdf_file))) {
            @unlink(public_path($upnews->pdf_file));
        }

        $pdf = $request->file('pdf_file');
        $name_pdf = hexdec(uniqid()) . '.' . $pdf->getClientOriginalExtension();

        $pdfDir = public_path('upload/news/pdf');
        if (!file_exists($pdfDir)) {
            mkdir($pdfDir, 0755, true);
        }

        $pdf->move($pdfDir, $name_pdf);
        $save_url_pdf = 'upload/news/pdf/' . $name_pdf;
    }
    // If delete checkbox is checked
    if ($request->has('delete_pdf') && $request->delete_pdf == 1) {
        if (!empty($upnews->pdf_file) && file_exists(public_path($upnews->pdf_file))) {
            @unlink(public_path($upnews->pdf_file));
        }
        $save_url_pdf = null;
    }
    
    
    
      // STATUS LOGIC (SCHEDULE / PUBLISH)
    $status = $request->status_option;

    if ($status == 3 && $request->publish_date) {
        if (Carbon::parse($request->publish_date)->gt(Carbon::now('Asia/Dhaka'))) {
            $status = 3;
        } else {
            $status = 1;
        }
    }
    
    
    

    // ------------------------
    // UPDATE FIELDS
    // ------------------------
    $upnews->category_id = $request->category_id;
    $upnews->subcategory_id = $request->subcategory_id ?? null;
    $upnews->district_id = $request->district_id ?? null;
    $upnews->thana_id = $request->thana_id ?? null;
    $upnews->upozila_thana_id = $request->upozila_thana_id;
    $upnews->user_id = $request->user_id; 
    $upnews->reporter = $request->reporter;

    $upnews->news_title = $request->news_title;
    $upnews->news_title_slug = strtolower(str_replace(' ', '-', $request->news_title)); 
    $upnews->img_title = $request->img_title ?? null;
    $upnews->news_shoulder = $request->news_shoulder ?? null;
    $upnews->news_hanger = $request->news_hanger ?? null;
    $upnews->news_details = $request->news_details;
    $upnews->tags = $request->tags ?? null;

    // booleans (ensure 0/1)
    $upnews->breaking_news = $request->breaking_news ? 1 : 0;
    $upnews->top_slider = $request->top_slider ? 1 : 0;
    $upnews->first_section_three = $request->first_section_three ? 1 : 0;
    $upnews->first_section_nine = $request->first_section_nine ? 1 : 0;
    $upnews->sukhobor = $request->sukhobor ? 1 : 0;
    $upnews->alocito = $request->alocito ? 1 : 0;
    $upnews->jatiyo = $request->jatiyo ? 1 : 0;
    $upnews->top_news = $request->top_news ? 1 : 0;
    
    
    $upnews->status_option = $status;
    $upnews->publish_date = $request->publish_date;
    $upnews->meta_desc = $request->meta_desc ?? null;
    $upnews->meta_keywords = $request->meta_keywords ?? null;

    $upnews->post_date = date('d-m-Y');
    $upnews->post_month = date('F');
    $upnews->updated_at = Carbon::now('Asia/Dhaka');
    if ($request->publish_date) {
        $upnews->created_at = Carbon::parse($request->publish_date, 'Asia/Dhaka');
    }

    // Set final file paths
    $upnews->image = $save_url;
    $upnews->pdf_file = $save_url_pdf;
    $upnews->pdf_title = $request->pdf_title ?? $upnews->pdf_title;
    $upnews->position = $request->position ?? 1;
    
    

    $upnews->save();

    return redirect()->back()->with([
        'message' => 'News Post Updated Successfully',
        'alert-type' => 'success'
    ]);
}





    


    // public function DeleteNewsPost($id){

    //     $post_image = NewsPost::findOrFail($id);
    //     $img = $post_image->image;
    //     unlink($img);

    //     NewsPost::findOrFail($id)->delete();

    //      $notification = array(
    //         'message' => 'News Post Deleted Successfully',
    //         'alert-type' => 'success'

    //     );
    //     return redirect()->back()->with($notification);

    // }// End Method


public function DeleteNewsPost($id)
{
    $news = NewsPost::findOrFail($id);

    // ------------------------
    // Delete Image (safe)
    // ------------------------
    if (!empty($news->image) && file_exists(public_path($news->image))) {
        @unlink(public_path($news->image));
    }

    // ------------------------
    // Delete PDF (safe)
    // ------------------------
    if (!empty($news->pdf_file) && file_exists(public_path($news->pdf_file))) {
        @unlink(public_path($news->pdf_file));
    }

    // ------------------------
    // Delete database record
    // ------------------------
    $news->delete();

    return redirect()->back()->with([
        'message'    => 'News Post Deleted Successfully',
        'alert-type' => 'success'
    ]);
}






    public function InactiveNewsPost($id){

        NewsPost::findOrFail($id)->update(['status' => 0]);

        $notification = array(
            'message' => 'News Post InActive',
            'alert-type' => 'info'

        );
        return redirect()->back()->with($notification);

    }// End Method

    public function ActiveNewsPost($id){

        NewsPost::findOrFail($id)->update(['status' => 1]);

        $notification = array(
            'message' => 'News Post Active',
            'alert-type' => 'info'

        );
        return redirect()->back()->with($notification);

    }// End Method
    
    
    
    
    
    
    // public function DeletePdfNewsPost($id){

    //     $post_pdf = NewsPost::findOrFail($id);
    //     $pdf = $post_pdf->pdf_file;
    //     unlink($pdf);

     

    //      $notification = array(
    //         'message' => 'Pdf file Deleted Successfully',
    //         'alert-type' => 'success'

    //     );
    //     return redirect()->back()->with($notification);

    // }
    
    



public function DeletePdfNewsPost($id)
{
    $post = NewsPost::find($id);

    $filePath = $post->pdf_file;

    if ($post->pdf_file && file_exists($filePath)) {
        unlink($filePath);
    }

    $post->update([
        'pdf_file' => null,
        'pdf_title' => null,
    ]);

    return redirect()->back()->with([
        'message' => 'PDF deleted successfully',
        'alert-type' => 'success'
    ]);
}





// public function UpdateNewsOrder(Request $request)
// {
//     foreach ($request->order as $key => $id) {
//         NewsPost::where('id', $id)->update(['sort_order' => $key + 1]);
//     }

//     return response()->json(['status' => 'success']);
// }



// public function UpdateNewsOrder(Request $request)
// {
//     $order = $request->order;

//     foreach ($order as $index => $id) {
//         App\Models\NewsPost::where('id', $id)->update(['position' => $index + 1]);
//     }

//     return response()->json(['status' => 'success']);
// }




public function updateOrder(Request $request)
{
    foreach ($request->order as $item) {
        NewsPost::where('id', $item['id'])
            ->update(['position' => $item['position']]);
    }

    return response()->json(['success' => true]);
}





public function NewsTopNine(){
    
    // $allnews = NewsPost::where('first_section_nine', 1)
    //         ->orderBy('id', 'desc')
    //         ->get();
    
    $allnews = NewsPost::where('first_section_nine', 1)
            ->where('position', '>', 0) 
            ->orderBy('position', 'ASC')
            ->get();

    
    return view('backend.news.all_news_post_nine', compact('allnews'));
    
    
}




public function NewsTest(){
    //   $allnews = NewsPost::orderBy('position', 'ASC')->take(10)->get();
    
        $user = Auth::user();
        $allnewsForAdmin = NewsPost::where('first_section_nine', 1)
            ->where('position', '>', 0) 
            ->orderBy('position', 'ASC')
            ->take(50)->get();
      
        $allnews = NewsPost::where('user_id', $user->id)->where('first_section_nine', 1)
            ->where('position', '>', 0) 
            ->orderBy('position', 'ASC')
            ->take(50)->get();
            
    return view('backend.news.nine_sec', compact('allnews', 'allnewsForAdmin'));
             
             
}





public function UpdateNewsOrder(Request $request)
{
    $order = $request->order; // array of IDs in new order

    foreach($order as $index => $id) {
        $news = NewsPost::find($id);
        if ($news) {
            $news->position = $index + 1; // update position in DB
            $news->save();
        }
    }

    return response()->json(['success' => true]);
}




public function AllScheduledNewsPost(){
   
    
     $user = Auth::user();

    // Common condition
    $baseQuery = NewsPost::where(function($query){
                        $query->orWhere('status_option', 3);
                    });

    // Admin → all news
    $allnews = $baseQuery->latest()->get();

    // Editor → only his own news
    $allEdittornews = $baseQuery->where('user_id', $user->id)
                                ->latest()
                                ->get();
        
        
        return view('backend.news.scheduled_news',compact('allnews', 'allEdittornews'));
             
}




 

} 
 