<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PhotoGallery;
use App\Models\NewsPost;
use Carbon\Carbon; 
use Intervention\Image\Facades\Image;

class PhotoGalleryController extends Controller
{
    public function AllPhotoGallery(){

        $photo = PhotoGallery::orderBy('id', 'desc')->get();
        return view('backend.photo.all_photo',compact('photo'));

    } // End Method 


    public function AddPhotoGallery(){
        return view('backend.photo.add_photo');
    }// End Method 


    // public function StorePhotoGallery(Request $request){

    //     $image = $request->file('multi_image');

    //     foreach($image as $mulit_image){
 
    //     $name_gen = hexdec(uniqid()).'.'.$mulit_image->getClientOriginalExtension();
    //     // Image::make($mulit_image)->resize(700,400)->save('upload/multi/'.$name_gen);
    //     mage::make($mulit_image)->save('upload/multi/'.$name_gen);
    //     $save_url = 'upload/multi/'.$name_gen;
        
    //     PhotoGallery::insert([
    //         'photo_gallery' => $save_url,
    //         'post_date' => Carbon::now()->format('d F Y'),
    //         'created_at' => now(),
    //         'updated_at' => now(),

    //     ]); 
    //     } // End Foreach

    //     $notification = array(
    //         'message' => 'Photo Gallery Inserted Successfully',
    //         'alert-type' => 'success'

    //     );
        
        
    //     // return redirect()->route('all.photo.gallery')->with($notification);
        
    //     return redirect()->route('media.photo')->with($notification);

    // }
    
    
    
    public function StorePhotoGallery(Request $request)
{
    if($request->hasFile('multi_image')){
        $images = $request->file('multi_image');

        foreach($images as $multi_image){
            $name_gen = hexdec(uniqid()).'.'.$multi_image->getClientOriginalExtension();
            $save_path = public_path('upload/multi/'.$name_gen);
            Image::make($multi_image)->save($save_path);
            $save_url = 'upload/multi/'.$name_gen;

            PhotoGallery::insert([
                'title' => $request->title,
                'description' => $request->description,
                'photo_gallery' => $save_url,
                'post_date' => Carbon::now()->format('d F Y'),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    $notification = [
        'message' => 'Photo Gallery Inserted Successfully',
        'alert-type' => 'success'
    ];

    return redirect()->route('media.photo')->with($notification);
}




    public function EditPhotoGallery($id){

        $photogallery = PhotoGallery::findOrFail($id);
        return view('backend.photo.edit_photo',compact('photogallery'));

    }// End Method 


    // public function UpdatePhotoGallery(Request $request){
    //     $photo_id = $request->id;

    //     if ($request->file('multi_image')) {
            
    // $image = $request->file('multi_image'); 
    // $name_gen = hexdec(uniqid()).'.'.$image->getClientOriginalExtension();
    // // Image::make($image)->resize(700,400)->save('upload/multi/'.$name_gen);
    // Image::make($image)->save('upload/multi/'.$name_gen);
    // $save_url = 'upload/multi/'.$name_gen;
        
    //     PhotoGallery::findOrFail($photo_id)->update([
    //         'title' => $request->title,
    //         'description' => $request->description,
    //         'photo_gallery' => $save_url,
    //         'post_date' => Carbon::now()->format('d F Y'),
    //         'created_at' => now(),
    //         'updated_at' => now(),

    //     ]); 

    //     $notification = array(
    //         'message' => 'Photo Gallery Updated Successfully',
    //         'alert-type' => 'success'

    //     );
    //     return redirect()->route('all.photo.gallery')->with($notification); 

    //     } // End If 

    // }
    
    
    public function UpdatePhotoGallery(Request $request){
    $photo_id = $request->id;
    $photo = PhotoGallery::findOrFail($photo_id);

    $save_url = $photo->photo_gallery; // default old image

    if ($request->hasFile('multi_image')) {
        $image = $request->file('multi_image'); 
        $name_gen = hexdec(uniqid()).'.'.$image->getClientOriginalExtension();
        Image::make($image)->save(public_path('upload/multi/'.$name_gen));
        $save_url = 'upload/multi/'.$name_gen;

        // Optional: Delete old image from server
        if(file_exists(public_path($photo->photo_gallery))){
            unlink(public_path($photo->photo_gallery));
        }
    }

    $photo->update([
        'title' => $request->title,
        'description' => $request->description,
        'photo_gallery' => $save_url,
        'post_date' => Carbon::now()->format('d F Y'),
        'updated_at' => now(),
    ]);

    $notification = [
        'message' => 'Photo Gallery Updated Successfully',
        'alert-type' => 'success'
    ];

    return redirect()->route('all.photo.gallery')->with($notification);
}



    public function DeletePhotoGallery($id){

        $photo = PhotoGallery::findOrFail($id);
        $img = $photo->photo_gallery;
        unlink($img);

        PhotoGallery::findOrFail($id)->delete();

        $notification = array(
            'message' => 'Photo Gallery Deleted Successfully',
            'alert-type' => 'success'

        );
        return redirect()->back()->with($notification); 


    }// End Method 
    
    
    
    // public function AllMediaPhotos(){
        
    //     $photo = PhotoGallery::orderBy('id', 'desc')->get();
        
    //     $medias = NewsPost::where('status', 1)->latest()->paginate(20);
        
    //     return view('backend.photo.media_photo', compact('photo', 'medias'));
    // }
    
  
  
  
  
//   public function AllMediaPhotos()
// {
//     // 1️⃣ Fetch Gallery Photos
//     $galleryPhotos = PhotoGallery::select('id', 'photo_gallery', 'post_date')
//         ->get()
//         ->map(function ($item) {
//             return [
//                 'id' => $item->id,
//                 'image' => $item->photo_gallery,   // gallery image column
//                 'type' => 'gallery',
//                 'created_at' => $item->created_at
//             ];
//         });

//     // 2️⃣ Fetch News Photos
//     $newsPhotos = NewsPost::where('status', 1)
//         ->select('id', 'image', 'created_at')
//         ->get()
//         ->map(function ($item) {
//             return [
//                 'id' => $item->id,
//                 'image' => $item->image,           // news image column
//                 'type' => 'news',
//                 'created_at' => $item->created_at
//             ];
//         });

//     // 3️⃣ Merge both collections and sort latest first
//     $allPhotos = $galleryPhotos
//                     ->merge($newsPhotos)
//                     ->sortByDesc('id')
//                     ->values();

//     return view('backend.photo.media_photo', compact('allPhotos'));
// }

    
    
    
//     public function AllMediaPhotos()
// {
//     // Fetch Gallery Photos
//     $galleryPhotos = PhotoGallery::select('id', 'photo_gallery', 'created_at')
//         ->get()
//         ->map(function ($item) {
//             return [
//                 'id' => $item->id,
//                 'image' => $item->photo_gallery,
//                 'type' => 'gallery',
//                 'created_at' => $item->created_at
//             ];
//         });

//     // Fetch News Photos
//     $newsPhotos = NewsPost::where('status', 1)
//         ->select('id', 'image', 'created_at')
//         ->get()
//         ->map(function ($item) {
//             return [
//                 'id' => $item->id,
//                 'image' => $item->image,
//                 'type' => 'news',
//                 'created_at' => $item->created_at
//             ];
//         });

//     // Merge & sort by created_at
//     $allPhotos = $galleryPhotos
//                     ->merge($newsPhotos)
//                     ->sortByDesc('created_at')  // ← CHANGED
//                     ->values();

//     return view('backend.photo.media_photo', compact('allPhotos'));
// }



public function AllMediaPhotos()
{
    
    
    $perPage = 20; // items per page

    // Fetch Gallery Photos
    $galleryPhotos = PhotoGallery::select('id', 'photo_gallery', 'created_at')
        ->get()
        ->map(function ($item) {
            return [
                'id' => $item->id,
                'image' => $item->photo_gallery,
                'type' => 'gallery',
                'created_at' => $item->created_at
            ];
        });

    // Fetch News Photos
    $newsPhotos = NewsPost::where('status', 1)
        ->select('id', 'image', 'created_at')
        ->get()
        ->map(function ($item) {
            return [
                'id' => $item->id,
                'image' => $item->image,
                'type' => 'news',
                'created_at' => $item->created_at
            ];
        });

    // Merge & sort by created_at
    $allData = $galleryPhotos
                ->merge($newsPhotos)
                ->sortByDesc('created_at')
                ->values();

    // Manual Pagination
    $currentPage = request()->get('page', 1);
    $items = $allData->slice(($currentPage - 1) * $perPage, $perPage)->values();

    $paginated = new \Illuminate\Pagination\LengthAwarePaginator(
        $items,
        $allData->count(),
        $perPage,
        $currentPage,
        ['path' => request()->url(), 'query' => request()->query()]
    );

    return view('backend.photo.media_photo', ['allPhotos' => $paginated]);
    
    
    
}

    
    



}
 