<?php




namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SalatTime;
use Carbon\Carbon; 
use Intervention\Image\Facades\Image;

use App\Models\Poll;

class PollController extends Controller
{
    // Show poll
    public function showingPolling()
    {
        $poll = Poll::where('status', 1)->latest()->first(); 
        
        
        return view('frontend.poll', compact('poll'));
    }

    // Handle vote
    // public function vote(Request $request, $id)
    // {
    //     $poll = Poll::findOrFail($id);

    //     if ($request->vote == 'yes') {
    //         $poll->increment('yes_votes');
    //     } elseif ($request->vote == 'no') {
    //         $poll->increment('no_votes');
    //     }

    //     return response()->json([
    //         'yes_votes' => $poll->yes_votes,
    //         'no_votes' => $poll->no_votes,
    //     ]);
    // }
    
     public function vote(Request $request, $id)
    {
        $poll = Poll::findOrFail($id);

        if ($request->vote === 'yes') {
            $poll->yes_votes += 1;
        } elseif ($request->vote === 'no') {
            $poll->no_votes += 1;
        }

        // Every click increases total_votes
        $poll->total_votes += 1;

        $poll->save();

        // Calculate updated percentages
        $yesPercent = $poll->total_votes > 0 ? round(($poll->yes_votes / $poll->total_votes) * 100, 1) : 0;
        $noPercent  = $poll->total_votes > 0 ? round(($poll->no_votes / $poll->total_votes) * 100, 1) : 0;

        return response()->json([
            'yes_votes' => $poll->yes_votes,
            'no_votes' => $poll->no_votes,
            'total_votes' => $poll->total_votes,
            'yes_percent' => $yesPercent,
            'no_percent' => $noPercent,
        ]);
    }
    
    
    
    public function result($id){
        $poll = Poll::findOrFail($id);
    
        $yesPercent = $poll->total_votes > 0 ? round(($poll->yes_votes / $poll->total_votes) * 100, 1) : 0;
        $noPercent  = $poll->total_votes > 0 ? round(($poll->no_votes / $poll->total_votes) * 100, 1) : 0;
    
        return response()->json([
            'yes_votes' => $poll->yes_votes,
            'no_votes' => $poll->no_votes,
            'total_votes' => $poll->total_votes,
            'yes_percent' => $yesPercent,
            'no_percent' => $noPercent
        ]);
    }



    
    
    
    
    
    
    
    public function allPolls(){
        $polls = Poll::orderBy('id', 'desc')->get();
        return view('backend.poll.index', compact('polls'));

    }
    
    
    public function createPoll(){
        return view('backend.poll.create');

    }
    
    
    // public function storePoll(Request $request){
    //     $poll = new Poll();
        
    //      if ($request->file('image')) {

    //         $image = $request->file('image');
    //         $name_gen = hexdec(uniqid()).'.'.$image->getClientOriginalExtension();
    //         Image::make($image)->save('upload/polls/'.$name_gen);
    //         $save_url = 'upload/polls/'.$name_gen;
            
    //      }
        
    //     $poll->questions = $request->questions;
    //     $poll->image = $save_url;
        
    //     $poll->save();
        
    //     return redirect()->route('all.polls')->with('success', 'New poll added successfully!');
    // }
    
    
    
    public function storePoll(Request $request){
        $poll = new Poll();
    
        if ($request->file('image')) {
            $image = $request->file('image');
            $name_gen = hexdec(uniqid()) . '.' . $image->getClientOriginalExtension();
            Image::make($image)->save('upload/polls/' . $name_gen);
            $save_url = 'upload/polls/' . $name_gen;
        } else {
            $save_url = null; // handle case when no image is uploaded
        }
    
        $poll->questions = $request->questions;
        $poll->image = $save_url; // ✅ Corrected line
        $poll->save();
    
        return redirect()->route('all.polls')->with('success', 'New poll added successfully!');
    }



    
    
    public function editPoll($id){
        $poll = Poll::find($id);
        return view('backend.poll.edit', compact('poll'));

    }
    
    
     public function updatePoll(Request $request){
        $poll = Poll::find($request->id);
        
        if ($request->file('image')) {

            // Delete old image if it exists
            if ($poll->image && file_exists(public_path($poll->image))) {
                unlink(public_path($poll->image));
            }
    
            $image = $request->file('image');
            $name_gen = hexdec(uniqid()) . '.' . $image->getClientOriginalExtension();
            Image::make($image)->save('upload/polls/' . $name_gen);
            $save_url = 'upload/polls/' . $name_gen;
    
            $poll->image = $save_url;
        }
            
        
        $poll->questions = $request->questions;
        $poll->total_votes = $request->total_votes;
         $poll->yes_votes = $request->yes_votes;
        $poll->no_votes = $request->no_votes;
        
        $poll->save();
        
        return redirect()->route('all.polls')->with('success', 'New poll updated successfully!');

    }
    
    
    
     public function deletePoll($id){
        $poll = Poll::find($id);
        
        if ($poll->image && file_exists(public_path($poll->image))) {
                unlink(public_path($poll->image));
            }
        
        $poll->delete();
        
        return redirect()->route('all.polls')->with('success', 'Poll deleted successfully!');

    }
    
    
    
    
    
    
    
}
