<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\District;
use App\Models\Thana;
use App\Models\UpozilaThana;
use App\Models\Subcategory;

class ThanaController extends Controller
{
    
     public function AllThana(){

        $thanas = Thana::with('division','district')->latest()->get();
        return view('backend.thana.thana_all',compact('thanas'));

    } // End Mehtod 

    public function AddThana(){

        $subcategories = Subcategory::orderBy('id', 'ASC')->limit(8)->get();
        // $districts = District::latest()->get();
        return view('backend.thana.thana_add',compact('subcategories'));

    } 

     public function StoreThana(Request $request){
// dd($request->all());
        Thana::insert([
            'district_id' => $request->district_id,
            'division_id' => $request->division_id,
            'name' => $request->name,
            'slug' => strtolower(str_replace(' ', '-', $request->name)),

        ]); 


         $notification = array(
            'message' => 'Thana Inserted Successfully',
            'alert-type' => 'success'

        );

        return redirect()->route('all.thana')->with($notification);


    }// End Mehtod 


    public function EditThana($id){

        $subcategories = Subcategory::orderBy('id', 'ASC')->limit(8)->get();
        $thana = Thana::findOrFail($id);
        $district = District::findOrFail($thana->district_id);
        // dd($district);
        return view('backend.thana.thana_edit',compact('thana','subcategories', 'district'));
    }// End Mehtod


 public function UpdateThana(Request $request){

       $subcat_id = $request->id;

       Thana::findOrFail($subcat_id)->update([
            'district_id' => $request->district_id,
            'division_id' => $request->division_id,
            'name' => $request->name,
            'slug' => strtolower(str_replace(' ', '-', $request->name)),

        ]); 


         $notification = array(
            'message' => 'Thana Updated Successfully',
            'alert-type' => 'success'

        );

        return redirect()->route('all.thana')->with($notification);


    }// End Mehtod 

     public function DeleteThana($id){

        Thana::findOrFail($id)->delete();

         $notification = array(
            'message' => 'Thana Deleted Successfully',
            'alert-type' => 'success'

        );

        return redirect()->back()->with($notification);

    }// End Mehtod 

 
    public function GetThana($district_id){

        $subcat = Thana::where('district_id',$district_id)->orderBy('name','ASC')->get();
            return json_encode($subcat);

    }// End Mehtod 





    public function AllUpozilaThana(){
        $upozilaThanas = UpozilaThana::with('division','district', 'upozila')->latest()->get();
        return view('backend.thana.upozila_thana_all',compact('upozilaThanas'));
    }



    public function AddUpozilaThana(){
        
         $subcategories = Subcategory::orderBy('id', 'ASC')->limit(18)->get();
        
        return view('backend.thana.add_upozila_thana', compact('subcategories'));
        
    }
    
    
    public function StoreUpozilaThana(Request $request){
         UpozilaThana::insert([
            'district_id' => $request->district_id,
            'division_id' => $request->division_id,
            'thana_id' => $request->thana_id,
            'name' => $request->name,
            'slug' => strtolower(str_replace(' ', '-', $request->name)),

        ]); 


         $notification = array(
            'message' => 'Upozila Thana Inserted Successfully',
            'alert-type' => 'success'

        );

        return redirect()->route('all.upozila.thana')->with($notification);
        
    }




 public function GetUpozilaThana($id){

        $subcat = UpozilaThana::where('thana_id',$id)->orderBy('name','ASC')->get();
            return json_encode($subcat);

    }// End Mehtod 





public function editUpozilaThana($id){
    return view('backend.thana.upozila_thana_edit');
}














}
 