<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\NewsPost;
use App\Models\Category;
use App\Models\Subcategory;
use App\Models\District;
use App\Models\Thana;
use App\Models\PhotoGallery;
use App\Models\VideoGallery;
use Carbon\Carbon; 
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Session;
use App;
use DateTime;
use App\Models\User;

use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Cache;

class IndexController extends Controller
{
    
  public function login() {
        return redirect()->route('admin.login');
    }
    
    public function Index(){
 
        $newnewspost = NewsPost::orderBy('id','DESC')->limit(25)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->limit(3)->get();
       

        $skip_cat_0 = Category::skip(0)->first();
        $skip_news_0 = NewsPost::where('status',1)->where('category_id',$skip_cat_0->id)->orderBy('id','DESC')->limit(7)->get();

        $skip_cat_2 = Category::skip(2)->first();
        $skip_news_2 = NewsPost::where('status',1)->where('category_id',$skip_cat_2->id)->orderBy('id','DESC')->limit(6)->get();

        $skip_cat_1 = Category::skip(1)->first();
        $skip_news_1 = NewsPost::where('status',1)->where('category_id',$skip_cat_1->id)->orderBy('id','DESC')->limit(5)->get();

        $skip_cat_3 = Category::skip(3)->first();
        $skip_news_3 = NewsPost::where('status',1)->where('category_id',$skip_cat_3->id)->orderBy('id','DESC')->limit(8)->get();

        $skip_cat_4 = Category::skip(4)->first();
        $skip_news_4 = NewsPost::where('status',1)->where('category_id',$skip_cat_4->id)->orderBy('id','DESC')->limit(7)->get();
        // dd($skip_cat_2);
        $skip_cat_5 = Category::skip(5)->first();
        $skip_news_5 = NewsPost::where('status',1)->where('category_id',$skip_cat_5->id)->orderBy('id','DESC')->limit(7)->get();
        
        $skip_cat_6 = Category::skip(6)->first();
        $skip_news_6 = NewsPost::where('status',1)->where('category_id',$skip_cat_6->id)->orderBy('id','DESC')->limit(7)->get();

        $skip_cat_7 = Category::skip(7)->first();
        $skip_news_7 = NewsPost::where('status',1)->where('category_id',$skip_cat_7->id)->orderBy('id','DESC')->limit(5)->get();
        
        $skip_cat_8 = Subcategory::find(83);
        $skip_news_8 = NewsPost::where('status',1)->where('subcategory_id',$skip_cat_8->id)->orderBy('id','DESC')->limit(5)->get();
        
        $skip_cat_9 =  Subcategory::find(84);
        $skip_news_9 = NewsPost::where('status',1)->where('subcategory_id',$skip_cat_9->id)->orderBy('id','DESC')->limit(8)->get();
        
        $skip_cat_10 = Category::find(12);
        $skip_news_10 = NewsPost::where('status',1)->where('category_id',$skip_cat_10->id)->orderBy('id','DESC')->limit(10)->get();
        
        $vibags = Subcategory::where('category_id', 8)->get();
        $thanas = Thana::all();
        
         
        

        //  dd('ok', $skip_cat_6->toArray());
        return view('frontend.index',compact('thanas', 'vibags', 'skip_cat_10', 'skip_news_10', 'skip_cat_3', 'skip_news_3', 'skip_cat_8', 'skip_news_8', 'skip_cat_9', 'skip_news_9', 'skip_cat_7', 'skip_news_7', 'skip_cat_5', 'skip_news_5', 'skip_cat_6', 'skip_news_6', 'newnewspost','newspopular','skip_cat_0','skip_news_0','skip_cat_2','skip_news_2','skip_cat_1','skip_news_1','skip_cat_4','skip_news_4'));
    } // End Method 


    public function allVideo(){
        $video = VideoGallery::latest()->get();
        return view('frontend.video',compact('video'));
    }
    
    
    
    
    public function NewsDetails($id,$slug){

        $news = NewsPost::findOrFail($id);
        // dd($news->toArray());
        $url = route('newsDetailsOne', $news->id);
        // dd($url);
        $title = $news->news_title;
        $summary = $news->news_title;
        $hashtags = $news->tags;
        $source = config('app.name');
        $tags = $news->tags;
        $tags_all = explode(',', $tags);

        $cat_id = $news->category_id;
        $relatedNews = NewsPost::where('category_id',$cat_id)->where('id','!=',$id)->orderBy('id','DESC')->limit(6)->get();
        

        $newsKey = 'blog' . $news->id;
        if (!Session::has($newsKey)) {
           $news->increment('view_count');
           Session::put($newsKey,1); 
        }

        $newnewspost = NewsPost::orderBy('id','DESC')->where('status_option',1)->limit(8)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->where('status_option',1)->limit(5)->get();

        return view('frontend.news.news_details',compact('news','tags_all','relatedNews','newnewspost','newspopular', 'url', 'title', 'summary', 'hashtags', 'source'));

    }// End Method 
    
    
    

    public function NewsDetailsOne($id){

        $news = NewsPost::findOrFail($id);
        // dd($news);
        $url = route('newsDetailsOne', $news->id);
        // dd($url);
        $title = $news->news_title;
        $summary = $news->news_title;
        $hashtags = $news->tags;
        $source = config('app.name');
        $tags = $news->tags;
        $tags_all = explode(',', $tags);

        $cat_id = $news->category_id;
        $relatedNews = NewsPost::where('category_id',$cat_id)->where('id','!=',$id)->orderBy('id','DESC')->limit(6)->get();

        $newsKey = 'news' . $news->id;
        if (!Session::has($newsKey)) {
        //   $news->increment('view_count');
            NewsPost::where('id', $id)->increment('view_count');
          Session::put($newsKey,1);
        }

        $newnewspost = NewsPost::orderBy('id','DESC')->where('status_option',1)->limit(8)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->where('status_option',1)->limit(5)->get();

        return view('frontend.news.news_details',compact('news','tags_all','relatedNews','newnewspost','newspopular', 'url', 'title', 'summary', 'hashtags', 'source'));

    }




    // public function CatWiseNews($id,$slug){

    //     // $news = NewsPost::where('status',1)->where('category_id',$id)->orderBy('id','DESC')->get();
        
    //     $news = NewsPost::where('status',1)
    //     ->where('category_id',$id)
    //     ->orderBy('id','DESC')
    //     ->paginate(20);

    //     $breadcat = Category::where('id',$id)->first();

    //     $newstwo = NewsPost::where('status',1)->where('category_id',$id)->orderBy('id','DESC')->limit(2)->get();

    //   $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
    //     $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();

    //     return view('frontend.news.category_news',compact('news','breadcat','newstwo','newnewspost','newspopular'));

    // }
    
    public function CatWiseNews(Request $request, $id, $slug){

    // Main news with pagination
    $news = NewsPost::where('status',1)
        ->where('category_id',$id)
        ->orderBy('id','DESC')
        ->paginate(12); // প্রতি পেজে 20টা নিউজ দেখাবে

    // Breadcrumb category
    $breadcat = Category::findOrFail($id);
    
    
    
      
      
      
      if ($request->ajax()) {
        $html = '';
        foreach ($news as $item) {
            $html .= '<div class="themesBazar-3 themesBazar-m2">
                    <div class="secOne-wrpp">
                        <div class="sectionOne-image2">
                            <img src="'.asset($item->image).'" alt="">
                        </div>
                        <h5 class="secOne_title">
                            <a href="'.url('news/details/'.$item->id).'" 
                               style="font-size:20px; font-weight:600; line-height:23px; display:inline-block">
                               '.$item->news_title.'
                            </a>
                        </h5>
                    </div>
                  </div>';
        }
        return $html;
    }
    
    

    // Sidebar latest 2 news (no problem here)
    $newstwo = NewsPost::where('status',1)
        ->where('category_id',$id)
        ->orderBy('id','DESC')
        ->limit(2)
        ->get();

    // Sidebar recent 8
    $newnewspost = NewsPost::orderBy('id','DESC')
        ->limit(8)
        ->get();

    // Sidebar popular 8
    $newspopular = NewsPost::orderBy('view_count','DESC')
        ->limit(8)
        ->get();

    return view('frontend.news.category_news',
        compact('news','breadcat','newstwo','newnewspost','newspopular')
    );
}

    // End Method


     public function SubCatWiseNews($id,$slug){

       
        
                $news = NewsPost::where('status',1)
                    ->where('subcategory_id',$id)
                    ->orderBy('id','DESC')
                    ->paginate(200);

        $breadsubcat = Subcategory::where('id',$id)->first();
        $alldistricts = District::where('division_id',$id)->get();

        $newstwo = NewsPost::where('status',1)->where('subcategory_id',$id)->orderBy('id','DESC')->limit(2)->get();

        $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();

        return view('frontend.news.subcategory_news',compact('news','alldistricts', 'breadsubcat','newstwo','newnewspost','newspopular'));

    }
    
    // End Method

     public function DistrictWiseNews($id,$slug){

        $news = NewsPost::where('status',1)->where('district_id',$id)->orderBy('id','DESC')->get();

        $breadsubcat = District::where('id',$id)->first();
        $allthanas = Thana::where('district_id',$id)->get();

        $newstwo = NewsPost::where('status',1)->where('district_id',$id)->orderBy('id','DESC')->limit(2)->get();

        $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();

        return view('frontend.news.district_news',compact('news','allthanas','breadsubcat','newstwo','newnewspost','newspopular'));

    }// End Method

     public function ThanaWiseNews($id,$slug){

        $news = NewsPost::where('status',1)->where('thana_id',$id)->orderBy('id','DESC')->get();

        $breadsubcat = Thana::where('id',$id)->first();

        $newstwo = NewsPost::where('status',1)->where('thana_id',$id)->orderBy('id','DESC')->limit(2)->get();

        $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();

        return view('frontend.news.thana_news',compact('news','breadsubcat','newstwo','newnewspost','newspopular'));

    }// End Method


    public function Change(Request $request){

        App::setLocale($request->lang);
        session()->put('locale',$request->lang);

        return redirect()->back();

    }// End Method

    public function SearchByDate(Request $request){
// dd($request->all());
        $searchDate = $request->year.'-'.$request->month.'-'.$request->day;
        // dd($searchDate);
        $date = new DateTime($searchDate);
        $formatDate = $date->format('d-m-Y');

        $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();

        $news = NewsPost::where('post_date',$formatDate)->latest()->get();
        // dd($news);
        return view('frontend.news.search_by_date',compact('news','formatDate','newnewspost','newspopular'));

    }// End Method
    public function allLatestNews(){
// dd('ok');
        $news = NewsPost::where('status_option',1)->latest()->paginate(60);
        // dd($news);
        $newnewspost = NewsPost::orderBy('id','DESC')->where('status_option',1)->limit(8)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->where('status_option',1)->limit(8)->get();
        // dd('ok');
        return view('frontend.news.latestnews',compact('news','newnewspost','newspopular'));

    }// End Method

    public function NewsSearch(Request $request){


        $request->validate(['search' => "required"]);

        $item = $request->search;

        $news = NewsPost::where('news_title','LIKE',"%$item%")->get();
        $newnewspost = NewsPost::orderBy('id','DESC')->where('status_option',1)->limit(8)->get();
        $newspopular = NewsPost::orderBy('view_count','DESC')->where('status_option',1)->limit(8)->get();

        return view('frontend.news.search',compact('news','newnewspost','newspopular','item'));


    }// End Method




//  public function NewsSearchByArea(Request $request){


//         $request->validate(['search' => "required"]);

//         $item = $request->search;

//         $news = NewsPost::where('news_title','LIKE',"%$item%")->get();
//         $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
//         $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();

//         return view('frontend.news.search',compact('news','newnewspost','newspopular','item'));


//     }

// public function NewsSearchByArea(Request $request)
// {
//     $subcategory = $request->subcategory_id;
//     $district = $request->district_id;
//     $thana = $request->thana_id;

//     $news = NewsPost::query();

//     if ($subcategory) {
//         $news->where('subcategory_id', $subcategory);
//     }

//     if ($district) {
//         $news->where('district_id', $district);
//     }

//     if ($thana) {
//         $news->where('thana_id', $thana);
//     }

//     $news = $news->orderBy('id','DESC')->get();
    
//      $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
//     $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();
    
//      $item = "Search By Area";

//     return view('frontend.news.search-by_area', compact('news', 'newnewspost', 'newspopular', 'item'));
// }



public function NewsSearchByArea(Request $request)
{
    $subcategory = $request->subcategory_id;
    $district = $request->district_id;
    $thana = $request->thana_id;
    
     // Selected Names
    $vibag = Subcategory::find($subcategory);
    $districtData = District::find($district);
    $thanaData = Thana::find($thana);
    
 
   


    // Default Query
    // $news = NewsPost::query();

    if ($subcategory && $district && $thana) {
        // বিভাগ + জেলা + উপজেলা selected
        $news = NewsPost::where('subcategory_id', $subcategory)
             ->where('district_id', $district)
             ->where('thana_id', $thana);

    } elseif ($subcategory && $district) {
        // বিভাগ + জেলা
        $news = NewsPost::where('subcategory_id', $subcategory)
             ->where('district_id', $district);

    } elseif ($subcategory) {
        // শুধু বিভাগ
        $news = NewsPost::where('subcategory_id', $subcategory);

    } elseif ($district && $thana) {
        // জেলা + উপজেলা
        $news = NewsPost::where('district_id', $district)
             ->where('thana_id', $thana);

    } elseif ($district) {
        // শুধু জেলা
       $news = NewsPost::where('district_id', $district);

    } elseif ($thana) {
        // শুধু উপজেলা
        $news = NewsPost::where('thana_id', $thana);
    }

    $news = $news->orderBy('id', 'DESC')->get();

    $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
    $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();

    $item = "Search By Area";

    return view('frontend.news.search_by_area', compact('news', 'newnewspost', 'newspopular', 'item', 'vibag', 'districtData', 'thanaData'));
}










    public function ReporterNews($id){

        $reporter = User::findOrFail($id);

        $news = NewsPost::where('user_id',$id)->paginate(12);;
        return view('frontend.reporter.reporter_news_post',compact('reporter','news'));

    }// End Method




    public function SubCatWiseNewsAll(){
        
        $sub_category = Subcategory::where('id', '98')->first();
         $news = NewsPost::where('status',1)->where('subcategory_id',$sub_category->id)->orderBy('id','DESC')->get();
         $newnewspost = NewsPost::orderBy('id','DESC')->limit(8)->get();
         $newspopular = NewsPost::orderBy('view_count','DESC')->limit(8)->get();
         
        return view('frontend.news.sompadok_news', compact('sub_category', 'news', 'newnewspost', 'newspopular'));
    }








// public function activeUsers()
// {
//     $activeVisitors = \DB::table('visitors')
//         ->where('last_activity', '>=', now()->subMinutes(5))
//         ->count();
        
        
//     $totalVisitors = \DB::table('visitors')->count();
    
//     $totalVisits = DB::table('visitor_logs')->count();


//     return view('frontend.visitors', compact('activeVisitors', 'totalVisitors', 'totalVisits'));
// }





// public function activeUsers()
// {
//     $activeVisitors = DB::table('visitors')
//         ->where('last_activity', '>=', now()->subMinutes(5))
//         ->count();

//     $totalVisitors = DB::table('visitors')->count();

//     $totalVisits = DB::table('visitor_logs')->count();
    
//     $last7DaysPageviews = DB::table('visitor_logs')
//     ->where('visited_at', '>=', now()->subDays(7))
//     ->count();

//     return view('frontend.visitors', compact('activeVisitors', 'totalVisitors', 'totalVisits'));
// }



public function activeUsers()
{
    $activeVisitors = DB::table('visitors')
        ->where('last_activity', '>=', now()->subMinutes(5))
        ->count();

    $totalVisitors = DB::table('visitors')->count();

    $totalVisits = DB::table('visitor_logs')->count();

    $last7DaysPageviews = DB::table('visitor_logs')
        ->where('visited_at', '>=', now()->subDays(30))
        ->count();

    $last7DaysVisitors = DB::table('visitor_logs')
        ->where('visited_at', '>=', now()->subDays(30))
        ->distinct('device_id')
        ->count('device_id');

    return view('frontend.visitors', compact(
        'activeVisitors',
        'totalVisitors',
        'totalVisits',
        'last7DaysPageviews',
        'last7DaysVisitors'
    ));
}



public function converter(){
    return view('frontend.converter');
}



public function singleGalleryImage($id){
    
    $imagePhoto = PhotoGallery::find($id);
    
    return view('frontend.gallery_image', compact('imagePhoto'));
    
    
}


public function allGalleryImage(){
 
     return view('frontend.all_gallery_image');
}


public function allVideos(){
 
     return view('frontend.all_videos');
}




















}
  