<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\NewsPost;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;

class AutoPublishScheduledPosts
{
    public function handle($request, Closure $next)
    {
        // প্রতি 1 মিনিটে একবার run হবে
        if (!Cache::has('auto_publish_checked')) {

            NewsPost::where('status_option', 3)
                ->whereNotNull('publish_date')
                ->where('publish_date', '<=', Carbon::now('Asia/Dhaka'))
                ->limit(5)
                ->update([
                    'status_option' => 1
                ]);

            Cache::put('auto_publish_checked', true, 60);
        }

        return $next($request);
    }
}
