<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\DB;

class TrackVisitors
{
    // public function handle($request, Closure $next)
    // {
    //     // Step 1: Device ID from cookie
    //     if (! $request->hasCookie('device_id')) {

    //         $deviceId = (string) Str::uuid();

    //         Cookie::queue('device_id', $deviceId, 60 * 24 * 365); // 1 year

    //         // First time visitor → insert new visitor row
    //         DB::table('visitors')->insert([
    //             'device_id'     => $deviceId,
    //             'ip'            => $request->ip(),
    //             'last_activity' => now(),
    //             'created_at'    => now(),
    //             'updated_at'    => now(),
    //         ]);

    //     } else {

    //         $deviceId = $request->cookie('device_id');

    //         // Update existing visitor
    //         DB::table('visitors')->updateOrInsert(
    //             ['device_id' => $deviceId],
    //             [
    //                 'ip'            => $request->ip(),
    //                 'last_activity' => now(),
    //                 'updated_at'    => now(),
    //             ]
    //         );
    //     }
        
        
        
        
    //      // STEP 3: Log every visit (visit count)
    // DB::table('visitor_logs')->insert([
    //     'device_id' => $deviceId,
    //     'ip' => $request->ip(),
    //     'visited_at' => now()
    // ]);
    
    
    
    
    

    //     return $next($request);
    // }
    
    
    
    
    
    public function handle($request, Closure $next)
{
    $deviceId = $request->cookie('device_id', (string) Str::uuid());

    if (! $request->hasCookie('device_id')) {
        Cookie::queue('device_id', $deviceId, 60 * 24 * 365); // 1 year
        DB::table('visitors')->insert([
            'device_id'     => $deviceId,
            'ip'            => $request->ip(),
            'last_activity' => now(),
            'created_at'    => now(),
            'updated_at'    => now(),
        ]);
    } else {
        DB::table('visitors')->updateOrInsert(
            ['device_id' => $deviceId],
            [
                'ip' => $request->ip(),
                'last_activity' => now(),
                'updated_at' => now()
            ]
        );
    }

    // Log every visit
    DB::table('visitor_logs')->insert([
        'device_id' => $deviceId,
        'ip' => $request->ip(),
        'visited_at' => now()
    ]);

    return $next($request);
}







    
    
    





}
