<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewsPost extends Model
{
    use HasFactory;

    public $timestamps = false; 
protected $casts = [
    'created_at' => 'datetime',
    'updated_at' => 'datetime',
];


  protected $fillable = [
        'news_title',
        'category_id',
        'subcategory_id',
        'news_details',
        'user_id',
        'image',
        'position'
    ];


    public function category(){
        return $this->belongsTo(Category::class,'category_id','id');
    }

    public function subcategory(){
        return $this->belongsTo(Subcategory::class,'subcategory_id','id');
    }

    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }
}

 