<?php

namespace App\Providers;

use Illuminate\Pagination\Paginator;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Carbon;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
         config(['app.locale' => 'bn']);
    Carbon::setLocale(config('app.locale'));
    
    // Set Laravel pagination to use Bootstrap 5
        Paginator::useBootstrapFive();

    // Set default timezone globally
    date_default_timezone_set(config('app.timezone'));
    }
}
