@extends('admin.admin_dashboard')

@section('title')

    Dashboard - The Daily Nawroj
    
@endsection


@section('admin')
    @php
        $id = Auth::user()->id;
        $userid = App\Models\User::find($id);
        $status = $userid->status;

        $allnews = App\Models\NewsPost::count();
        $activenews = App\Models\NewsPost::where('status',1)->count();
        $inactivenews = App\Models\NewsPost::where('status',0)->count();
        $breakingnews = App\Models\NewsPost::where('breaking_news',1)->count();
    @endphp
    
    
   <style>
   
    .mobile-only {
        display:none;
    }

/* desktop screen only */
@media (max-width: 768px){
    .desktop-only{
        display: none; /* row হলে flex ভালো */
    }
    .mobile-only {
        display:block;
    }
}
</style>
    
    

    <div class="content">

        @if ($status == 'active')
            <h4> Account Is <span class="text-success">Active  </span> </h4>
        @else
            <h4>Admin Account Is <span class="text-danger">InActive </span> </h4>
            <p class="text-danger"><b>Plz wait admin will check and approve your account</b></p>
        @endif

        <!-- Start Content-->
        <div class="container-fluid">
            
        <div class="row mobile-only">
            
            <div class="col-md-12">
                <img src="https://nawroj.com/frontend/assets/images/logonaw.png" class="w-100">
            </div>
            
        </div>


 <div class="row desktop-only">
     
    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="avatar-lg rounded-circle bg-primary border-primary border shadow">
                            <i class="fe-heart font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"> <span data-plugin="counterup">{{ $allnews }}</span></h3>
                            <p class="text-muted mb-1 text-truncate">All News Post</p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->

    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="avatar-lg rounded-circle bg-success border-success border shadow">
                            <i class="fe-thumbs-up font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $activenews }}</span></h3>
                            <p class="text-muted mb-1 text-truncate">Active News dfdfdfd</p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->

    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="avatar-lg rounded-circle bg-info border-info border shadow">
                            <i class="fe-thumbs-down font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $inactivenews }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate">InActive News</p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->

    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="avatar-lg rounded-circle bg-warning border-warning border shadow">
                            <i class="fe-eye font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $breakingnews }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate">Breaking News</p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->
    
    
    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-3">
                        <div class="avatar-lg rounded-circle bg-warning border-warning border shadow">
                            <i class="fe-user font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-9">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $activeVisitors }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate"> Active Visitors </p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->
    
    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-3">
                        <div class="avatar-lg rounded-circle bg-warning border-warning border shadow">
                            <i class="fe-user font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-9">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $totalVisitors }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate"> Total Visitors </p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->
    
     <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-3">
                        <div class="avatar-lg rounded-circle bg-warning border-warning border shadow">
                            <i class="fe-user font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-9">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $totalVisits }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate"> Total View </p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->
    
    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-3">
                        <div class="avatar-lg rounded-circle bg-warning border-warning border shadow">
                            <i class="fe-user font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-9">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $last7DaysPageviews }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate"> Last 7 Days View </p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->
    
    
     <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-3">
                        <div class="avatar-lg rounded-circle bg-warning border-warning border shadow">
                            <i class="fe-user font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-9">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $last7DaysVisitors }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate"> Last 7 Days Visitor </p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->
    
</div>
<!-- end row-->


            <!-- end row-->




        </div> <!-- container -->

    </div> <!-- content -->
@endsection
