@extends('admin.admin_dashboard')
@section('admin')
    <!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    {{-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script> --}}

    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script>

    <div class="content">

        <!-- Start Content-->
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">

                                <li class="breadcrumb-item active">Edit News Post</li>
                            </ol>
                        </div>
                        <h4 class="page-title">Edit News Post</h4>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <!-- Form row -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <form id="myForm" method="post" action="{{ route('update.news.post') }}"
                                enctype="multipart/form-data">
                                @csrf

                                <input type="hidden" name="id" value="{{ $newspost->id }}">

                                <div class="row">
                                    <div class="form-group col-md-6 mb-3">
                                        <label for="inputEmail4" class="form-label">Category Name </label>
                                        <select name="category_id" class="form-select" id="example-select">
                                            <option value="">Select Category </option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}"
                                                    {{ $category->id == $newspost->category_id ? 'selected' : '' }}>
                                                    {{ $category->category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                   
                                    <div class="form-group col-md-6 mb-3">
                                        <label for="inputEmail4" class="form-label"> Sub Category </label>
                                        <select name="subcategory_id" class="form-select" id="example-select">
                                            <option value="">Select One SubCaategory/Division</option>
                                             @if($subcats)
                                            <option value="{{ $subcats->id }}" selected> {{ $subcats->subcategory_name }} </option>
                                            @endif

                                        </select>
                                    </div>

                                    <div class="form-group col-md-6 mb-3">
                                        <label for="inputEmail4" class="form-label">District Name </label>
                                        <select name="district_id" class="form-select" id="example-select">
                                            <option value=""> Select One District </option>
                                            @if($district)
                                            <option value="{{ $district->id }}" selected> {{ $district->name }} </option>
                                            @endif
                                        </select>
                                    </div>

                                
                                    <div class="form-group col-md-6 mb-3">
                                        <label for="inputEmail4" class="form-label">Thana Name </label>
                                        <select name="thana_id" class="form-select" id="example-select">
                                            <option value=""> Select One Thana </option>
                                            @if($thana)
                                            <option value="{{ $thana->id }}" selected> {{ $thana->name }} </option>
                                            @endif
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6 mb-3">
                                        <label for="inputEmail4" class="form-label">Reporter </label>
                                        <select name="user_id" class="form-select" id="example-select">
                                            <option value="">Select Writer </option>
                                            @foreach ($adminuser as $user)
                                                <option value="{{ $user->id }}"
                                                    {{ $user->id == $newspost->user_id ? 'selected' : '' }}>
                                                    {{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="form-group col-md-12 mb-3">
                                        <label for="inputEmail4" class="form-label">News Title </label>
                                        <input type="text" name="news_title" class="form-control" id="inputEmail4"
                                            value="{{ $newspost->news_title }}">
                                    </div>


                                    <div class="form-group col-md-12 mb-3">
                                        <label for="inputEmail4" class="form-label">News Shoulder </label>
                                        <input type="text" name="news_shoulder" class="form-control" id=""
                                            value="{{ $newspost->news_shoulder }}">
                                    </div>

                                    <div class="form-group col-md-12 mb-3">
                                        <label for="inputEmail4" class="form-label">News Hanger </label>
                                        <input type="text" name="news_hanger" class="form-control" id=""
                                            value="{{ $newspost->news_hanger }}">
                                    </div>

                                    <div class="form-group col-md-6 mb-3">
                                        <label for="example-fileinput" class="form-label">News Post Photo</label>
                                        <input type="file" name="image" id="image" class="form-control">
                                    </div>
                                    
                                    <div class="form-group col-md-6 mb-3">
                                        <label for="inputEmail4" class="form-label">Image Title </label>
                                        <input type="text" name="img_title" class="form-control" id=""
                                            value="{{ $newspost->img_title }}">
                                    </div>

                                    <div class="form-group col-md-6 mb-3">
                                        <label for="example-fileinput" class="form-label"> </label>
                                        <img id="showImage" src="{{ asset($newspost->image) }}"
                                            class="rounded-circle avatar-lg img-thumbnail" alt="profile-image">
                                    </div>



                                    <div class="col-12 mb-3">
                                        <label for="inputEmail4" class="form-label">News Details </label>
                                        <textarea id="summernote" name="news_details">
                {!! $newspost->news_details !!}
            </textarea>
                                    </div>


                                    <div class="col-6 mb-3">
                                        <label for="inputEmail4" class="form-label">Meta Description </label>
                                        <textarea id="" name="meta_desc" class="form-control">{{ $newspost->meta_desc }}</textarea>
                                    </div>

                                    <div class="col-6 mb-3">
                                        <label for="inputEmail4" class="form-label">Meta Keywords </label>
                                        <textarea id="" name="meta_keywords" class="form-control">{{ $newspost->meta_keywords }}</textarea>
                                    </div>

                                    <div class="form-group col-md-6 mb-3">
                                        <label for="inputEmail4" class="form-label">Tags </label>
                                        <input type="text" name="tags" class="selectize-close-btn"
                                            value="{{ $newspost->tags }}">
                                    </div>



                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-check mb-2 form-check-primary">
                                                <input class="form-check-input" type="checkbox" name="breaking_news"
                                                    value="1" id="customckeck1"
                                                    {{ $newspost->breaking_news == 1 ? 'checked' : '' }}>
                                                <label class="form-check-label" for="customckeck1">Breaking News</label>
                                            </div>

                                            <div class="form-check mb-2 form-check-primary">
                                                <input class="form-check-input" type="checkbox" name="top_slider"
                                                    value="1" id="customckeck2"
                                                    {{ $newspost->top_slider == 1 ? 'checked' : '' }}>
                                                <label class="form-check-label" for="customckeck2">Top Slider</label>
                                            </div>

                                        </div>




                                        <div class="col-lg-6">
                                            <div class="form-check mb-2 form-check-danger">
                                                <input class="form-check-input" name="first_section_three"
                                                    type="checkbox" value="1" id="customckeck3"
                                                    {{ $newspost->first_section_three == 1 ? 'checked' : '' }}>
                                                <label class="form-check-label" for="customckeck3">সম্পাদকীয় </label>
                                            </div>

                                            <div class="form-check mb-2 form-check-danger">
                                                <input class="form-check-input" name="first_section_nine" type="checkbox"
                                                    value="1" id="customckeck4"
                                                    {{ $newspost->first_section_nine == 1 ? 'checked' : '' }}>
                                                <label class="form-check-label" for="customckeck4">First Section
                                                    Nine</label>
                                            </div>

                                        </div>

                                    </div>
                                    
                                    
                                       
                                    <div class="row">
                                        
                                         <div class="col-lg-6">                                         

                                              <div class="form-check mb-2 form-check-danger">
                                                  <input class="form-check-input" name="sukhobor" type="checkbox"
                                                      value="1" id="customckeck6" {{ $newspost->sukhobor == 1 ? 'checked' : '' }}>
                                                  <label class="form-check-label" for="customckeck6"> সুখবর </label>
                                              </div>
                                            
                                            </div>
                                            
                                            
                                              <div class="col-lg-6">
                                                  <div class="form-check mb-2 form-check-danger">
                                                      <input class="form-check-input" name="alocito" type="checkbox"
                                                         value="1" id="customckeck5"  {{ $newspost->alocito == 1 ? 'checked' : '' }} >
                                                      <label class="form-check-label" for="customckeck5">আলোচিত</label>
                                                  </div>
                                              </div>
                                        
                                        
                                    </div>
                                    
                                    
                                    
                                    <div class="row mt-4">
                                            <div class="col-lg-12">
                                                <h3 class="additionalFeature" style="color:#000; cursor:pointer;">
                                                    Additional Features 
                                                    <i class="fa-solid fa-chevron-down"></i>
                                                    <i class="fa-solid fa-chevron-up" style="display:none;"></i>
                                                </h3>
                                            </div>
                                            
                                            <div class="col-lg-12 row featureSections" style="display:none;">
                                                <div class="col-lg-6">
                                                    <label for="pdf_title" class="form-label">Pdf Title</label>
                                                    <input type="text" name="pdf_title" class="form-control" id="pdf_title" value="{{ $newspost->pdf_title }}">
                                                </div>
                                                <div class="col-lg-6">
                                                    <label for="pdf_file" class="form-label">Pdf File</label>
                                                    <input type="file" name="pdf_file" class="form-control" id="pdf_file">
                                                    
                                                    @if(!empty($newspost->pdf_file))
                                                        <div class="mt-2">
                                                            <a href="{{ asset($newspost->pdf_file) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                                📄 View PDF
                                                            </a>
                                                        </div>
                                                    @endif


                                                </div>
                                            </div>
                                            
                                            <hr class="mt-3" style="border-bottom:2px solid #aaa" />
                                        </div>
                                        
                                        
                                        
                                        




                                </div>



                                <button type="submit" class="btn btn-primary waves-effect waves-light">Save
                                    Changes</button>

                            </form>

                        </div> <!-- end card-body -->
                    </div> <!-- end card-->
                </div> <!-- end col -->
            </div>
            <!-- end row -->



        </div> <!-- container -->

    </div> <!-- content -->

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs5.min.css"
        integrity="sha512-ngQ4IGzHQ3s/Hh8kMyG4FC74wzitukRMIcTOoKT3EyzFZCILOPF0twiXOQn75eDINUfKBYmzYn2AA8DkAk8veQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Summernote JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote.min.js"
        integrity="sha512-6rE6Bx6fCBpRXG/FWpQmvguMWDLWMQjPycXMr35Zx/HRD9nwySZswkkLksgyQcvrpYMx0FELLJVBvWFtubZhDQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        
        
        
        
        
          
<script>
$(document).ready(function(){
    $(".additionalFeature").click(function(){
        $(".featureSections").slideToggle(300);
        $(this).find(".fa-chevron-down, .fa-chevron-up").toggle(); // toggle icons
    });
});
</script>





    <script type="text/javascript">
        $('#summernote').summernote({
            height: 400
        });
    </script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#myForm').validate({
                rules: {
                    news_title: {
                        required: true,
                    },
                },
                messages: {
                    news_title: {
                        required: 'Please Enter News Title',
                    },
                },
                errorElement: 'span',
                errorPlacement: function(error, element) {
                    error.addClass('invalid-feedback');
                    element.closest('.form-group').append(error);
                },
                highlight: function(element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function(element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                },
            });
        });
    </script>



    <script type="text/javascript">
        $(document).ready(function() {
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>


    
<script type="text/javascript">
    $(document).ready(function() {
        $('select[name="category_id"]').on('change', function() {
            var category_id = $(this).val();
            if (category_id) {
                $.ajax({
                    url: "{{ url('/subcategory/ajax') }}/" + category_id,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="subcategory_id"]').html('');
                        $('select[name="district_id"]').html('');
                        $('select[name="thana_id"]').html('');
                        var d = $('select[name="subcategory_id"]').empty();
                        $('select[name="subcategory_id"]').append(
                                '<option value="0">--select--</option>');
                        $.each(data, function(key, value) {
                            $('select[name="subcategory_id"]').append(
                                '<option value="' + value.id + '"> ' + value
                                .subcategory_name + '</option>');
                        });
                    },
                });
            } else {
                alert('danger');
            }
        });
    });
</script>

    
<script type="text/javascript">
    $(document).ready(function() {
        $('select[name="subcategory_id"]').on('change', function() {
            var subcategory_id = $(this).val();
            if (subcategory_id) {
                $.ajax({
                    url: "{{ url('/district/ajax') }}/" + subcategory_id,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="district_id"]').html('');
                        $('select[name="thana_id"]').html('');
                        var d = $('select[name="district_id"]').empty();
                            $('select[name="district_id"]').append(
                                    '<option value="0">--select--</option>');
                        $.each(data, function(key, value) {
                            $('select[name="district_id"]').append(
                                '<option value="' + value.id + '"> ' + value
                                .name + '</option>');
                        });
                    },
                });
            } else {
                alert('danger');
            }
        });
    });
</script>
    
<script type="text/javascript">
    $(document).ready(function() {
        $('select[name="district_id"]').on('change', function() {
            var district_id = $(this).val();
            if (district_id) {
                $.ajax({
                    url: "{{ url('/thana/ajax') }}/" + district_id,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="thana_id"]').html('');
                        var d = $('select[name="thana_id"]').empty();
                            $('select[name="thana_id"]').append(
                                    '<option value="0">--select--</option>');
                        $.each(data, function(key, value) {
                            $('select[name="thana_id"]').append(
                                '<option value="' + value.id + '"> ' + value
                                .name + '</option>');
                        });
                    },
                });
            } else {
                alert('danger');
            }
        });
    });
</script>

@endsection
