@extends('admin.admin_dashboard')

@section('title')
    All News Posts - The Daily Nawroj
@endsection

@section('admin') 

@php
    $activenews = App\Models\NewsPost::where('status',1)->count();
    $inactivenews = App\Models\NewsPost::where('status',0)->count();
    $breakingnews = App\Models\NewsPost::where('breaking_news',1)->count();
@endphp

<style>
#newsTable td, 
#newsTable th {
    white-space: normal !important;
    word-wrap: break-word;
    word-break: break-word;
}

#newsTable td:nth-child(3),
#newsTable th:nth-child(3) {
    max-width: 150px;
    white-space: normal !important;
}

.ui-state-highlight {
    height: 50px;
    background: #ffe9b3 !important;
    border: 2px dashed #f0a500;
}

.cursor-move {
    cursor: move;
}
</style>

<div class="content">
    <div class="container-fluid">
        
               
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <a href="{{ route('add.news.post') }}" class="btn btn-blue waves-effect waves-light">Add News Post</a>
                </ol>
            </div>
    
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

<br>

 <div class="row">
    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="avatar-lg rounded-circle bg-primary border-primary border shadow">
                            <i class="fe-heart font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"> <span data-plugin="counterup">{{ $allnews->count() }}</span></h3>
                            <p class="text-muted mb-1 text-truncate">All News Post</p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->

    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="avatar-lg rounded-circle bg-success border-success border shadow">
                            <i class="fe-thumbs-up font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $activenews }}</span></h3>
                            <p class="text-muted mb-1 text-truncate">Active News</p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->

    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="avatar-lg rounded-circle bg-info border-info border shadow">
                            <i class="fe-thumbs-down font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $inactivenews }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate">InActive News</p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->

    <div class="col-md-6 col-xl-3">
        <div class="widget-rounded-circle card">
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="avatar-lg rounded-circle bg-warning border-warning border shadow">
                            <i class="fe-eye font-22 avatar-title text-white"></i>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <h3 class="text-dark mt-1"><span data-plugin="counterup">{{ $breakingnews }}</span> </h3>
                            <p class="text-muted mb-1 text-truncate">Breaking News</p>
                        </div>
                    </div>
                </div> <!-- end row-->
            </div>
        </div> <!-- end widget-rounded-circle-->
    </div> <!-- end col-->
</div>
<!-- end row-->



        
        

        <div class="row mb-3">
            <div class="col-md-4">
                <input type="text" id="titleSearch" class="form-control" placeholder="Search by news title...">
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                     <table class="table table-hover" id="newsTable">
    <thead>
        <tr>
            <th>SL</th>
            <th>Position</th>
            <th>Image</th>
            <th>Title</th>
            <th>ID</th>
            <th>Category</th>
            
            <th>Date</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($allnews as $key => $item)
        <tr data-id="{{ $item->id }}" class="cursor-move">
            <td>{{ $key + 1 }}</td>
            <td>{{ $item->position }}</td>
            <td><img src="{{ asset($item->image) }}" style="width:50px;height:50px;"></td>
            <td>{{ $item->news_title }}</td>
            <td>{{ $item->id }}</td>
            <td>{{ $item['category']['category_name'] ?? '' }}</td>
          
            <td>{{ Carbon\Carbon::parse($item->created_at)->diffForHumans() }}</td>
            <td>
                <a href="{{ route('edit.news.post',$item->id) }}" class="btn btn-sm btn-primary">Edit</a>
                <a href="{{ route('delete.news.post',$item->id) }}" class="btn btn-sm btn-danger" id="delete">Delete</a>
                <a href="{{ url('news/details/' . $item->id) }}" target="_blank" class="btn btn-sm btn-primary">View</a>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>


                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>





<script>


// $(function() {
//     // Fix table rows for sortable
//     $("#newsTable tbody").sortable({
//         items: "> tr",
//         cursor: "move",
//         helper: function(e, ui) {
//             ui.children().each(function() {
//                 $(this).width($(this).width());
//             });
//             return ui;
//         },
//         placeholder: "ui-state-highlight",
//         start: function(e, ui){
//             ui.placeholder.height(ui.helper.outerHeight());
//         },
//         update: function(event, ui) {
//             let order = [];
//             $('#newsTable tbody tr').each(function(index){
//                 order.push($(this).data('id'));
//                 $(this).find('td:nth-child(2)').text(index + 1); // update position column
//             });

//             $.ajax({
//                 url: "{{ route('news.update.order') }}",
//                 type: "POST",
//                 data: {
//                     order: order,
//                     _token: "{{ csrf_token() }}"
//                 },
//                 success: function(res){
//                     console.log("Order updated successfully");
//                 }
//             });
//         }
//     }).disableSelection();

//     // Search by title
//  // Search by news title (better version)
// // Search/filter by news title
// $('#titleSearch').on('keyup', function() {
//     let searchText = $(this).val().toLowerCase().trim();

//     $('#newsTable tbody tr').each(function() {
//         let newsTitle = $(this).find('td').eq(3).text().toLowerCase().trim(); // 0-based index: 3 = Title column
//         if(newsTitle.includes(searchText)){
//             $(this).show();  // show rows that match
//         } else {
//             $(this).hide();  // hide rows that don't match
//         }
//     });
// });


    
    
// });

$(document).ready(function() {

    // Make tbody sortable
    $("#newsTable tbody").sortable({
        items: "> tr",
        cursor: "move",
        handle: "td:first", // drag only from first column
        helper: function(e, tr) {
            var $originals = tr.children();
            var $helper = tr.clone();
            $helper.children().each(function(index){
                $(this).width($originals.eq(index).width());
            });
            return $helper;
        },
        placeholder: "ui-state-highlight",
        start: function(e, ui){
            ui.placeholder.height(ui.helper.outerHeight());
        },
        update: function(event, ui) {
            let order = [];
            $('#newsTable tbody tr').each(function(index){
                order.push($(this).data('id'));
                $(this).find('td:nth-child(2)').text(index + 1);
            });

            $.ajax({
                url: "{{ route('news.update.order') }}",
                type: "POST",
                data: {
                    order: order,
                    _token: "{{ csrf_token() }}"
                },
                success: function(res){
                    console.log("Order updated successfully");
                }
            });
        }
    }).disableSelection();

    // Search by news title
    $('#titleSearch').on('keyup', function() {
        let searchText = $(this).val().toLowerCase().trim();
        $('#newsTable tbody tr').each(function() {
            let newsTitle = $(this).find('td').eq(3).text().toLowerCase().trim();
            $(this).toggle(newsTitle.includes(searchText));
        });
    });

});















$("#newsTable tbody").sortable({
    items: "> tr",
    cursor: "move",
    handle: "td:first", // Only drag by first column
    helper: function(e, tr) {
        var $originals = tr.children();
        var $helper = tr.clone();
        $helper.children().each(function(index){
            $(this).width($originals.eq(index).width());
        });
        return $helper;
    },
    placeholder: "ui-state-highlight",
    start: function(e, ui){
        ui.placeholder.height(ui.helper.outerHeight());
    },
    update: function(event, ui) {
        let order = [];
        $('#newsTable tbody tr').each(function(index){
            order.push($(this).data('id'));
            $(this).find('td:nth-child(2)').text(index + 1);
        });

        $.ajax({
            url: "{{ route('news.update.order') }}",
            type: "POST",
            data: {
                order: order, // array of news IDs in new order
                _token: "{{ csrf_token() }}"
            },
            success: function(res){
                console.log("Order updated successfully");
            }
        });
        
        
    }
}).disableSelection();




</script>




@endsection
