@extends('admin.admin_dashboard')

@section('title')

    Add Gallery Photo - The Daily Nawroj
    
@endsection

@section('admin')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            
                                            <li class="breadcrumb-item active">Add Multi Photo</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Add Multi Photo</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
  
                        <!-- Form row -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                         
    <form id="myForm" method="post" action="{{ route('store.photo.gallery') }}" enctype="multipart/form-data">
    	@csrf 
    	
        <div class="row">
            <div class="form-group col-md-8 mb-3">
                <label for="inputEmail4" class="form-label">Add Photo  </label>
  <input type="file" name="multi_image[]" class="form-control" id="multiImg" multiple="" >

                <div class="row" id="preview_img"></div>

            </div>
            
            
            <div class="form-group col-md-8 mb-3">
                <label for="title" class="form-label">Title  </label>
                    <input type="text" name="title" class="form-control" id="title"  >

             

            </div>
            
            
            
            <div class="form-group col-md-8 mb-3">
                <label for="description" class="form-label">Description  </label>
                <textarea id="description" name="description">{{old('description')}}</textarea>

                

            </div>
             
        </div>
 
                                          

   <button type="submit" class="btn btn-primary waves-effect waves-light">Save Changes</button>

                                        </form>

                                    </div> <!-- end card-body -->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

 
                        
                    </div> <!-- container -->

                </div> <!-- content -->
                
                
                
                
<script src="https://cdn.tiny.cloud/1/abcd1234/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>



<script>



// tinymce.init({
//     selector: '#mytextarea',
//     height: 400,
//     menubar: true,
//     plugins: [
//       'advlist autolink lists link image charmap print preview anchor',
//       'searchreplace visualblocks code fullscreen',
//       'insertdatetime media table paste code help wordcount'
//     ],
//     toolbar: 'undo redo | formatselect | bold italic backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help',
//     content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:14px }'
// });



ClassicEditor
        .create( document.querySelector( '#description' ) )
        .catch( error => {
            console.error( error );
        } );
  
  
  
</script>



 <script> 
 
  $(document).ready(function(){
   $('#multiImg').on('change', function(){ //on file input change
      if (window.File && window.FileReader && window.FileList && window.Blob) //check File API supported browser
      {
          var data = $(this)[0].files; //this file data
           
          $.each(data, function(index, file){ //loop though each file
              if(/(\.|\/)(gif|jpe?g|png|webp)$/i.test(file.type)){ //check supported file type
                  var fRead = new FileReader(); //new filereader
                  fRead.onload = (function(file){ //trigger function on successful read
                  return function(e) {
                      var img = $('<img/>').addClass('thumb').attr('src', e.target.result) .width(100)
                  .height(80); //create image element 
                      $('#preview_img').append(img); //append image to output element
                  };
                  })(file);
                  fRead.readAsDataURL(file); //URL representing the file's data.
              }
          });
           
      }else{
          alert("Your browser doesn't support File API!"); //if File API is absent
      }
   });
  });
   
  </script>
  
  



@endsection 