@extends('admin.admin_dashboard')

@section('title')

    All Online Polls - The Daily Nawroj
    
@endsection


@section('admin') 





 <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <a href="{{ route('create.poll') }}" class="btn btn-blue waves-effect waves-light">Add New Poll</a>
                </ol>
            </div>
                                    <h4 class="page-title"> All Polls </h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
 

        <table id="basic-datatable" class="table dt-responsive nowrap w-100">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>Poll Title </th>
                    <th>Yes Votes </th>
                    <th>No Votes </th>
                    <th>Total Votes </th>
                    <th>Image </th>
                    <th>Action </th> 
                </tr>
            </thead>
        
        
            <tbody>
            	@foreach($polls as $key=> $item)
                <tr>
                    <td>{{ $key+1 }}</td>
                    <td style="white-space: normal; overflow-wrap: break-word; max-width: 200px;">
                        {{ $item->questions }}
                    </td>
                    <td>{{ $item->yes_votes ?? '0' }}</td>
                    <td>{{ $item->no_votes ?? '0' }}</td>
                    <td>{{ $item->total_votes ?? '0' }}</td>
                    <td><img src="{{ $item->image }}" alt="" style="width:75px; height:50px"> </td>
                    <td>
                        
                      <a href="{{ route('edit.poll', $item->id) }}" class="btn btn-primary rounded-pill waves-effect waves-light">Edit</a>
                
                
                      <a href="{{ route('delete.poll', $item->id) }}" class="btn btn-danger rounded-pill waves-effect waves-light" id="delete">Delete</a>

                    </td> 
                </tr>
                @endforeach
                 
            </tbody>
        </table>

                                    </div> <!-- end card body-->
                                </div> <!-- end card -->
                            </div><!-- end col-->
                        </div>
                        <!-- end row-->

 
                        
                    </div> <!-- container -->

                </div> <!-- content -->

@endsection



