@extends('admin.admin_dashboard')

@section('title')

    Prayer Time Settings - The Daily Nawroj
    
@endsection

@section('admin')


<div class="content">

  <!-- Start Content-->
  <div class="container-fluid">

    <!-- start page title -->
    <div class="row">
      <div class="col-12">
        <div class="page-title-box">
          <div class="page-title-right">
            <ol class="breadcrumb m-0">

              <li class="breadcrumb-item active">Update Prayer Time </li>
            </ol>
          </div>
          <h4 class="page-title">Update Prayer Time</h4>
        </div>
      </div>
    </div>
    <!-- end page title -->

    <!-- Form row -->
    <div class="row">
      <div class="col-12">
        <div class="card">
          <div class="card-body">
              
              @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show my-3 w-50" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif



            <form id="myForm" method="post" action="{{ route('update.salat.time') }}" enctype="multipart/form-data">
              @csrf

              <input type="hidden" name="id" value="{{ $salat->id }}">

              <div class="row">


                <div class="form-group col-md-7 mb-3">
                  <label for="fajr" class="form-label">Fajr Time</label>
                  <input type="text" name="fajr" id="fajr" class="form-control" value="{{ $salat->fajr }}">
                </div>
                
                <div class="form-group col-md-7 mb-3">
                  <label for="dhuhr" class="form-label">Dhuhr Time</label>
                  <input type="text" name="dhuhr" id="dhuhr" class="form-control" value="{{ $salat->dhuhr }}">
                </div>
                
                <div class="form-group col-md-7 mb-3">
                  <label for="asr" class="form-label">Asr Time</label>
                  <input type="text" name="asr" id="asr" class="form-control" value="{{ $salat->asr }}">
                </div>
                
                <div class="form-group col-md-7 mb-3">
                  <label for="maghrib" class="form-label">Maghrib Time</label>
                  <input type="text" name="maghrib" id="maghrib" class="form-control" value="{{ $salat->maghrib }}">
                </div>
                
                <div class="form-group col-md-7 mb-3">
                  <label for="isha" class="form-label">Isha Time</label>
                  <input type="text" name="isha" id="isha" class="form-control" value="{{ $salat->isha }}">
                </div>
                
                <div class="form-group col-md-7 mb-3">
                  <label for="date" class="form-label">Date</label>
                  <input type="text" name="date" id="date" class="form-control" value="{{ $salat->date }}">
                </div>
                
                
                <div class="form-group col-md-7 mb-3">
                  <label for="weather" class="form-label">Weather</label>
                  <input type="text" name="weather" id="weather" class="form-control" value="{{ $salat->weather }}">
                </div>



              </div>



              <button type="submit" class="btn btn-primary waves-effect waves-light">Save Changes</button>

            </form>

          </div> <!-- end card-body -->
        </div> <!-- end card-->
      </div> <!-- end col -->
    </div>
    <!-- end row -->



  </div> <!-- container -->

</div> <!-- content -->

 

@endsection 