<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>নওরোজ । সত্য প্রকাশে নির্ভীক - ইউনিকোড-বিজয় কনভার্টার</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;500;700&display=swap" rel="stylesheet">
  
  
  
  <link rel="stylesheet" href="/front/css/style.css">
  
  <style>
  
  @font-face {
    font-family: 'SutonnyMJ';
    src: url('/front/fonts/SutonnyMJ-Regular.ttf') format('truetype');
    font-weight: normal;
    font-style: normal;
}

@font-face {
    font-family: 'Kalpurush';
    src: url('../fonts/kalpurush.ttf') format('truetype');
    /*font-weight: normal;*/
    /*font-style: normal;*/
}



@font-face {
    font-family: 'SolaimanLipiNormal';
    src: url('fonts/solaiman-lipi.eot');
    src: url('fonts/solaiman-lipi.eot') format('embedded-opentype'),
         url('fonts/solaiman-lipi.woff') format('woff'),
         url('fonts/solaiman-lipi.ttf') format('truetype'),
         url('fonts/solaiman-lipi.svg#SolaimanLipiNormal') format('svg');
	
	font-weight:normal;font-style:normal;
}



</style>
  
  
  <style>
    body{background:#f8f9fa;font-family:'Noto Sans Bengali', Arial, sans-serif}
    .header{padding:20px 0;margin-bottom:30px;background:#fff;box-shadow:0 4px 12px rgba(0,0,0,.08)}
    .logoo img{height:80px}
    .section-title{font-size:1.25rem;color:#0d47a1;border-bottom:3px solid #0d47a1;padding-bottom:8px;margin-bottom:12px}
    .converter-box{background:#fff;border-radius:10px;padding:22px;box-shadow:0 4px 12px rgba(0,0,0,.06)}
    .text-area{width:100%;min-height:230px;padding:12px;border:2px solid #e0e0e0;border-radius:8px;font-size:1.05rem;resize:vertical}
    .btn-custom{padding:10px 22px;border-radius:30px;font-weight:600;margin:6px}
    .btn-unicode-to-bijoy{background:#1976d2;color:#fff;border:none}
    .btn-bijoy-to-unicode{background:#43a047;color:#fff;border:none}
    .btn-clear{background:#e53935;color:#fff;border:none}
    .alert-custom{position:fixed;top:100px;right:20px;min-width:300px;z-index:1050}
    .chat-icon{position:fixed;right:20px;bottom:20px;background:#25d366;width:60px;height:60px;border-radius:50%;display:flex;align-items:center;justify-content:center;box-shadow:0 4px 10px rgba(0,0,0,.25);z-index:1000}
 
    #bijoyText {
      font-family: 'SutonnyMJ', sans-serif;
    }
 
    #unicodeText {
        font-family: 'SolaimanLipiNormal', sans-serif;
    }
 
  </style>
  
  
  
</head>
<body>
  <div class="header">
    <div class="container text-center">
      <div class="logoo"><a href="{{ route('index') }}"><img src="https://monoputo.nawroj.com/frontend/assets/images/logonaw.png" alt="নওরোজ"></a></div>
    </div>
  </div>

  <div class="container">
    <div class="converter-box">
      <div class="row">
        <div class="col-lg-6 mb-4">
          <h2 class="section-title">
            <i class="fas fa-globe me-2"></i>ইউনিকোড লেখা এখানে পেস্ট করুন
          </h2>
          <textarea id="unicodeText" class="text-area" placeholder="ইউনিকোড ফন্টে লিখিত বাংলা টেক্সট এখানে পেস্ট করুন..."></textarea>
          <div class="mt-3 text-center">
            <button id="unicodeToBijoyBtn" class="btn btn-custom btn-unicode-to-bijoy"><i class="fas fa-arrow-right me-2"></i>ইউনিকোড → বিজয়</button>
            <button id="clearUnicodeBtn" class="btn btn-custom btn-clear"><i class="fas fa-trash-alt me-2"></i>পরিষ্কার</button>
          </div>
        </div>

        <div class="col-lg-1 d-none d-lg-flex align-items-center justify-content-center">
          <i class="fas fa-exchange-alt fa-2x" style="color:#0d47a1"></i>
        </div>

        <div class="col-lg-5 mb-4">
          <h2 class="section-title">
            <i class="fas fa-keyboard me-2"></i>বিজয় লেখা এখানে পেস্ট করুন
          </h2>
          <textarea id="bijoyText" class="text-area" placeholder="বিজয় ফন্টে লিখিত বাংলা টেক্সট এখানে পেস্ট করুন..."></textarea>
          <div class="mt-3 text-center">
            <button id="bijoyToUnicodeBtn" class="btn btn-custom btn-bijoy-to-unicode"><i class="fas fa-arrow-left me-2"></i>বিজয় → ইউনিকোড</button>
            <button id="clearBijoyBtn" class="btn btn-custom btn-clear"><i class="fas fa-trash-alt me-2"></i>পরিষ্কার</button>
          </div>
        </div>
      </div>

      
    </div>
  </div>

  <!--<a href="https://wa.me/8801700000000" target="_blank" class="chat-icon"><img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="Chat" style="width:34px"></a>-->

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
  /*************************************************************************
   * Improved Unicode <-> Bijoy converter (best-effort)
   * - Conjuncts handled first
   * - Larger mapping tables
   * - Pre-kar (ি) & other matra re-ordering adjustments
   *
   * NOTE: This is a pragmatic, general-purpose converter. For 100% fidelity
   * on all legacy documents, further corner-case tuning may be required.
   *************************************************************************/

  // -------------------------
  // 1) SPECIAL CONJUNCTS MAP
  // Replace multi-char conjuncts first (Unicode -> placeholder Bijoy)
  // -------------------------
  const specialConjunctsUniToBijoy = [
    {u: /ক্ষ/g, b: '¶'},
    {u: /জ্ঞ/g, b: '¡'},
    {u: /শ্র/g, b: 'kª'},
    {u: /জ্ঞ/g, b: '¡'},
    {u: /র্\u200D?/g, b: 'iæ'}, // rare reph forms (normalize)
    // add more composite patterns if needed
  ];

  // Bijoy -> Unicode special (reverse)
  const specialConjunctsBijoyToUni = [
    {b: /¶/g, u: 'ক্ষ'},
    {b: /¡/g, u: 'জ্ঞ'},
    {b: /kª/g, u: 'শ্র'},
    {b: /iæ/g, u: 'র্'},
  ];

  // -------------------------
  // 2) Primary mapping tables (more comprehensive)
  // Note: Bijoy uses many ASCII symbols; this table is extended but still
  // may need additions depending on source Bijoy dialect/version.
  // -------------------------
  const unicodeToBijoyMap = {
    // independent vowels
    'অ':'Av','আ':'A','ই':'B','ঈ':'C','উ':'D','ঊ':'E','ঋ':'F','এ':'G','ঐ':'H','ও':'I','ঔ':'J',
    // consonants
    'ক':'K','খ':'L','গ':'M','ঘ':'N','ঙ':'O','চ':'P','ছ':'Q','জ':'R','ঝ':'S','ঞ':'T',
    'ট':'U','ঠ':'V','ড':'W','ঢ':'X','ণ':'Y','ত':'Z','থ':'_','দ':'`','ধ':'a','ন':'b',
    'প':'c','ফ':'d','ব':'e','ভ':'f','ম':'g','য':'h','র':'i','ল':'j','শ':'k','ষ':'l',
    'স':'m','হ':'n','ড়':'o','ঢ়':'p','য়':'q','ৎ':'r','ং':'M','ঃ':':','ঁ':'N',
    // dependent vowels (matras)
    'া':'v','ি':'w','ী':'x','ু':'y','ূ':'z','ৃ':'ó','ে':'s','ৈ':'t','ো':'u','ৌ':'~',
    // nukta/halant
    '্':'æ',
    // digits
    '০':'0','১':'1','২':'2','৩':'3','৪':'4','৫':'5','৬':'6','৭':'7','৮':'8','৯':'9'
  };

  const bijoyToUnicodeMap = {};
  // auto-fill reverse map
  for (const k in unicodeToBijoyMap) {
    bijoyToUnicodeMap[ unicodeToBijoyMap[k] ] = k;
  }
  // ensure some Bijoy multi-char sequences map correctly (override if needed)
  bijoyToUnicodeMap['Av'] = 'অ'; // keep multi-char mappings

  // -------------------------
  // 3) Utility: escape regex for strings
  // -------------------------
  function escRE(s){ return s.replace(/[.*+?^${}()|[\]\\]/g,'\\$&'); }

  // -------------------------
  // 4) Unicode -> Bijoy conversion
  // Steps:
  //  a) Normalize (NFC)
  //  b) replace special conjuncts
  //  c) process chars: handle consonant+halant clusters and matra reordering
  //  d) replace remaining characters by mapping
  // -------------------------
  function unicodeToBijoy(input) {
    if (!input) return input;
    let text = input.normalize ? input.normalize('NFC') : input;

    // a) special conjuncts first
    for (const s of specialConjunctsUniToBijoy) {
      text = text.replace(s.u, s.b);
    }

    // b) handle reph: 'র' + halant + consonant -> Bijoy uses leading 'i' or 'iæ' variants
    // We'll convert 'র্' to placeholder 'iæ' then later it will be processed
    text = text.replace(/র্/g, 'iæ');

    // c) reorder pre-kar (ি) and pre-vowel (ে,ৈ)
    // In Unicode logical order: consonant + virama + ...; pre-kar (ি) is stored after consonant
    // Bijoy places certain vowel markers differently; we approximate by moving 'ি' right after consonant's bijoy symbol
    // We'll convert cluster-by-cluster: C + 'ি'  => bijoyCharFor(ি) placed after consonant mapping.
    // Simpler approach: temporarily mark pre-kar positions to ensure mapping places them correctly.

    // replace each Unicode char by placeholder Bijoy (for most characters)
    // but handle consonant+matra cases carefully
    // Build arrays for processing by codepoints
    const chars = Array.from(text);
    let out = '';
    for (let i=0;i<chars.length;i++){
      const ch = chars[i];
      const next = chars[i+1] || '';
      const next2 = chars[i+2] || '';

      // If current is consonant and next is halant (virama) => keep consonant mapping + halant-symbol 'æ'
      if (unicodeIsConsonant(ch) && next === '্') {
        // consonant + halant: map consonant then halant symbol
        out += mapUnicodeChar(ch) + (unicodeToBijoyMap['্'] || 'æ');
        i++; // skip halant
        continue;
      }

      // consonant + pre-kar or matra handling: handle sequences like ক + ি  (ka + i-kar)
      if (unicodeIsConsonant(ch) && next === 'ি') {
        // Bijoy representation: place 'w' after consonant mapping but in some fonts 'w' visually before.
        out += mapUnicodeChar(ch) + (unicodeToBijoyMap['ি'] || 'w');
        i++; // skip matra
        continue;
      }

      // vowel signs that may need special placement: 'ে','ৈ' are vowel signs that in bijoy often comes before consonant visually.
      // For simplicity, if we see consonant+ে, place bijoy 's' immediately after consonant mapping.
      if (unicodeIsConsonant(ch) && next === 'ে') {
        out += mapUnicodeChar(ch) + (unicodeToBijoyMap['ে'] || 's');
        i++;
        continue;
      }

      // General mapping fallback
      out += mapUnicodeChar(ch);
    }

    // finally return
    return out;
  }

  // helper: return true if Unicode char is consonant in Bengali block (approx)
  function unicodeIsConsonant(ch){
    const consonants = "কখগঘঙচছজঝঞটঠডঢণতথদধনপফবভমযরলশষসহড়ঢ়য়";
    return consonants.indexOf(ch) !== -1;
  }

  function mapUnicodeChar(ch){
    if (unicodeToBijoyMap[ch] !== undefined) return unicodeToBijoyMap[ch];
    // if it's ASCII punctuation/digit etc, return as-is
    return ch;
  }

  // -------------------------
  // 5) Bijoy -> Unicode conversion
  // Steps:
  //  a) convert special placeholders
  //  b) parse Bijoy stream left-to-right trying to match multi-char keys first
  //  c) apply post-processing: convert our halant 'æ' back to '্' etc.
  // -------------------------
  function bijoyToUnicode(input){
    if (!input) return input;
    let t = input;

    // a) special placeholders to Unicode sequences (we reverse specialBijoy first)
    for (const s of specialConjunctsBijoyToUni) {
      t = t.replace(s.b, s.u);
    }

    // b) iterate and match longest possible bijoy tokens
    let out = '';
    for (let i=0;i<t.length;i++){
      // try two-char and three-char tokens first (Bijoy has multi-char like 'Av', 'iæ', 'kª' etc.)
      const two = (t[i] || '') + (t[i+1] || '');
      const three = two + (t[i+2] || '');
      if (bijoyToUnicodeMap[three]) {
        out += bijoyToUnicodeMap[three];
        i += 2;
      } else if (bijoyToUnicodeMap[two]) {
        out += bijoyToUnicodeMap[two];
        i += 1;
      } else if (bijoyToUnicodeMap[t[i]]) {
        out += bijoyToUnicodeMap[t[i]];
      } else {
        // unknown char: pass through (punctuation, spaces, latin, etc.)
        out += t[i];
      }
    }

    // replace our halant placeholder (æ) back to Unicode virama '্'
    out = out.replace(/æ/g, '্');

    // handle reph placeholder 'iæ' -> 'র্' (we converted earlier)
    out = out.replace(/iæ/g, 'র্');

    // Re-ordering cleanup: bijoy sometimes emits 'ি' in wrong position for some combinations; attempt small fixes
    // Example: if sequence 'ি' appears after vowel/consonant sequence where it should be before, do heuristic fixes (not exhaustive)
    // (More advanced logic would be required for perfect fidelity.)
    return out;
  }

  // -------------------------
  // 6) DOM wiring + alerts
  // -------------------------
  const unicodeTextarea = document.getElementById('unicodeText');
  const bijoyTextarea = document.getElementById('bijoyText');
  const unicodeToBijoyBtn = document.getElementById('unicodeToBijoyBtn');
  const bijoyToUnicodeBtn = document.getElementById('bijoyToUnicodeBtn');
  const clearUnicodeBtn = document.getElementById('clearUnicodeBtn');
  const clearBijoyBtn = document.getElementById('clearBijoyBtn');

  function showAlert(message, type){
    const existing = document.querySelector('.alert-custom');
    if (existing) existing.remove();
    const el = document.createElement('div');
    el.className = 'alert alert-' + (type==='success'?'success':'info') + ' alert-dismissible fade show alert-custom';
    el.innerHTML = `<strong>${type==='success'?'সফল!':'তথ্য:'}</strong> ${message} <button type="button" class="btn-close" data-bs-dismiss="alert"></button>`;
    document.body.appendChild(el);
    setTimeout(()=>{ if (el.parentNode) el.remove(); }, 3000);
  }

  unicodeToBijoyBtn.addEventListener('click', function(){
    const u = unicodeTextarea.value;
    const converted = unicodeToBijoy(u);
    bijoyTextarea.value = converted;
    showAlert('ইউনিকোড থেকে বিজয়ে রূপান্তর সম্পন্ন হয়েছে!', 'success');
  });

  bijoyToUnicodeBtn.addEventListener('click', function(){
    const b = bijoyTextarea.value;
    const converted = bijoyToUnicode(b);
    unicodeTextarea.value = converted;
    showAlert('বিজয় থেকে ইউনিকোডে রূপান্তর সম্পন্ন হয়েছে!', 'success');
  });

  clearUnicodeBtn.addEventListener('click', function(){ unicodeTextarea.value=''; showAlert('ইউনিকোড টেক্সট পরিষ্কার করা হয়েছে!', 'info'); });
  clearBijoyBtn.addEventListener('click', function(){ bijoyTextarea.value=''; showAlert('বিজয় টেক্সট পরিষ্কার করা হয়েছে!', 'info'); });

  // optional sample text
  window.addEventListener('load', function(){
    // sample Unicode (you can change for testing)
    unicodeTextarea.value = "বাংলা ভাষার জটিল যুক্তাক্ষর ও কার-বিচারে এই টুলটি পরীক্ষামূলকভাবে কাজ করবে। যদি কোনো কেস ভুল হয়, টেক্সট দিয়ে দেখান — আমি সেটি ঠিক করে দেবো।";
    bijoyTextarea.value = "";
  });

  </script>
</body>
</html>
