<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Professional Polling System</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --success-color: #4cc9f0;
            --danger-color: #f72585;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --gray-color: #6c757d;
            --border-radius: 12px;
            --box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            --transition: all 0.3s ease;
        }

        body {
            background-color: #f5f7fb;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--dark-color);
            line-height: 1.6;
        }

        .poll-container {
            max-width: 800px;
            margin: 2rem auto;
            padding: 0 15px;
        }

        .poll-card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            transition: var(--transition);
            margin-bottom: 2rem;
        }

        .poll-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.12);
        }

        .poll-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 1.5rem;
            text-align: center;
        }

        .poll-header h3 {
            margin: 0;
            font-weight: 600;
            font-size: 1.5rem;
        }

        .poll-body {
            padding: 2rem;
        }

        .poll-image {
            width: 100%;
            max-height: 300px;
            object-fit: cover;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }

        .poll-options {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        @media (max-width: 576px) {
            .poll-options {
                flex-direction: column;
            }
        }

        .vote-btn {
            flex: 1;
            padding: 1rem 1.5rem;
            border: none;
            border-radius: var(--border-radius);
            font-weight: 600;
            font-size: 1.1rem;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .vote-btn:hover {
            transform: translateY(-2px);
        }

        .vote-btn-yes {
            background-color: rgba(76, 201, 240, 0.15);
            color: #0d6efd;
            border: 2px solid rgba(76, 201, 240, 0.3);
        }

        .vote-btn-yes:hover {
            background-color: rgba(76, 201, 240, 0.25);
            border-color: rgba(76, 201, 240, 0.5);
        }

        .vote-btn-no {
            background-color: rgba(247, 37, 133, 0.15);
            color: #dc3545;
            border: 2px solid rgba(247, 37, 133, 0.3);
        }

        .vote-btn-no:hover {
            background-color: rgba(247, 37, 133, 0.25);
            border-color: rgba(247, 37, 133, 0.5);
        }

        .poll-results {
            background-color: var(--light-color);
            border-radius: var(--border-radius);
            padding: 1.5rem;
            margin-top: 1.5rem;
        }

        .poll-results h4 {
            margin-bottom: 1rem;
            color: var(--primary-color);
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .result-item {
            margin-bottom: 1rem;
        }

        .result-label {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.5rem;
            font-weight: 500;
        }

        .progress {
            height: 10px;
            border-radius: 5px;
            background-color: #e9ecef;
            overflow: hidden;
        }

        .progress-bar-yes {
            background: linear-gradient(90deg, #4cc9f0, #4895ef);
        }

        .progress-bar-no {
            background: linear-gradient(90deg, #f72585, #b5179e);
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 1rem;
            margin-top: 1.5rem;
        }

        @media (max-width: 576px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }

        .stat-card {
            background: white;
            border-radius: var(--border-radius);
            padding: 1rem;
            text-align: center;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .stat-value {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.25rem;
        }

        .stat-label {
            font-size: 0.9rem;
            color: var(--gray-color);
        }

        .refresh-info {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            margin-top: 1rem;
            color: var(--gray-color);
            font-size: 0.9rem;
        }

        .footer {
            text-align: center;
            margin-top: 3rem;
            padding: 1.5rem;
            color: var(--gray-color);
            font-size: 0.9rem;
        }
    </style>
</head>
<body>

    <div class="poll-container">
        <div class="poll-card">
            <div class="poll-header">
                <h3>{{ $poll->questions }}</h3>
            </div>
            <div class="poll-body">
                @if($poll->image)
                    <img src="{{ $poll->image }}" alt="Poll Image" class="poll-image">
                @endif

                <div class="poll-options">
                    <button class="vote-btn vote-btn-yes" data-vote="yes">
                        <i class="fas fa-check-circle"></i> Yes
                    </button>
                    <button class="vote-btn vote-btn-no" data-vote="no">
                        <i class="fas fa-times-circle"></i> No
                    </button>
                </div>

                <div class="poll-results">
                    <h4><i class="fas fa-chart-bar"></i> Live Results</h4>

                    <div class="result-item">
                        <div class="result-label">
                            <span>✅ Yes</span>
                            <span id="yes-result">0% (0 votes)</span>
                        </div>
                        <div class="progress">
                            <div id="yes-progress" class="progress-bar progress-bar-yes" role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>

                    <div class="result-item">
                        <div class="result-label">
                            <span>❌ No</span>
                            <span id="no-result">0% (0 votes)</span>
                        </div>
                        <div class="progress">
                            <div id="no-progress" class="progress-bar progress-bar-no" role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>

                    <div class="stats-grid">
                        <div class="stat-card">
                            <div class="stat-value" id="total-votes">0</div>
                            <div class="stat-label">Total Votes</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-value" id="yes-percent">0%</div>
                            <div class="stat-label">Yes Votes</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-value" id="no-percent">0%</div>
                            <div class="stat-label">No Votes</div>
                        </div>
                    </div>

                    <div class="refresh-info">
                        <i class="fas fa-sync-alt"></i> Results update automatically every 5 seconds
                    </div>
                </div>
            </div>
        </div>

        <div class="footer">
           
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        $(document).ready(function() {
            const csrfToken = $('meta[name="csrf-token"]').attr('content');
            const pollId = {{ $poll->id }};

            function loadPollResult() {
                axios.get(`/poll/result/${pollId}`)
                    .then(function(response) {
                        const res = response.data;

                        $('#yes-progress').css('width', `${res.yes_percent}%`).attr('aria-valuenow', res.yes_percent);
                        $('#no-progress').css('width', `${res.no_percent}%`).attr('aria-valuenow', res.no_percent);

                        $('#yes-result').text(`${res.yes_percent}% (${res.yes_votes} votes)`);
                        $('#no-result').text(`${res.no_percent}% (${res.no_votes} votes)`);

                        $('#total-votes').text(res.total_votes.toLocaleString());
                        $('#yes-percent').text(`${res.yes_percent}%`);
                        $('#no-percent').text(`${res.no_percent}%`);
                    })
                    .catch(function(error) {
                        console.error(error.response ? error.response.data : error);
                    });
            }

            loadPollResult();

            $('.vote-btn').click(function() {
                const vote = $(this).data('vote');

                axios.post(`/poll/vote/${pollId}`, { vote: vote }, {
                    headers: { 'X-CSRF-TOKEN': csrfToken }
                })
                .then(function(response) {
                    loadPollResult();
                })
                .catch(function(error) {
                    console.error(error.response ? error.response.data : error);
                });
            });

            setInterval(loadPollResult, 5000);
        });
    </script>
</body>
</html>
