<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Poll System</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Axios -->
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .poll-container {
            max-width: 600px;
            margin: 50px auto;
        }

        .poll-box {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 6px 20px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s ease;
        }

        .poll-box:hover {
            transform: translateY(-5px);
        }

        .poll-box h3 {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .poll-box img {
            border-radius: 8px;
            margin-bottom: 20px;
            max-width: 100%;
            height: auto;
        }

        .vote-btn {
            width: 120px;
            margin: 10px;
            font-size: 1rem;
            font-weight: 600;
            border-radius: 50px;
            transition: 0.3s;
        }

        .vote-btn:hover {
            transform: scale(1.05);
        }

        #result {
            margin-top: 25px;
            background: #f1f3f5;
            padding: 15px;
            border-radius: 8px;
        }

        #result p {
            margin: 5px 0;
            font-weight: 500;
        }

        .header {
            text-align: center;
            margin-top: 30px;
            margin-bottom: 30px;
        }

        .header h1 {
            font-weight: 700;
            color: #343a40;
        }
    </style>
</head>
<body>

    <div class="header">
        <h1>📊 Voting Poll</h1>
        <p class="text-muted">Cast your vote and see live results</p>
    </div>

    <div class="poll-container">
        <div class="poll-box">
            <h3>{{ $poll->questions }}</h3>

            @if($poll->image)
                <img src="{{ $poll->image }}" alt="Poll Image">
            @endif

            <div>
                <button class="btn btn-success vote-btn" data-vote="yes">✅ Yes</button>
                <button class="btn btn-danger vote-btn" data-vote="no">❌ No</button>
            </div>

            <div id="result"></div>
        </div>
    </div>

    <script>
    $(document).ready(function() {
        const csrfToken = $('meta[name="csrf-token"]').attr('content');
        const pollId = {{ $poll->id }};

        // Function to load current poll result
        function loadPollResult() {
            axios.get(`/poll/result/${pollId}`)
                .then(function(response) {
                    const res = response.data;
                    $('#result').html(`
                        <p>Total Votes: <strong>${res.total_votes}</strong></p>
                        <p>✅ Yes: <strong>${res.yes_votes}</strong> (${res.yes_percent}%)</p>
                        <p>❌ No: <strong>${res.no_votes}</strong> (${res.no_percent}%)</p>
                    `);
                })
                .catch(function(error) {
                    console.error(error.response ? error.response.data : error);
                });
        }

        // Initial load for all visitors
        loadPollResult();

        // Voting button click
        $('.vote-btn').click(function() {
            const vote = $(this).data('vote');

            axios.post(`/poll/vote/${pollId}`, {
                vote: vote
            }, {
                headers: {
                    'X-CSRF-TOKEN': csrfToken
                }
            })
            .then(function(response) {
                loadPollResult();
            })
            .catch(function(error) {
                console.error(error.response ? error.response.data : error);
            });
        });

        // Auto-refresh poll result every 5 seconds
        setInterval(loadPollResult, 5000);
    });
    </script>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
