<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\UserController;
use App\Http\Middleware\RedirectIfAuthenticated;

use App\Http\Controllers\Frontend\IndexController;
use App\Http\Controllers\Frontend\ReviewController; 

use App\Http\Controllers\Backend\CategoryController;
use App\Http\Controllers\Backend\DistrictController;
use App\Http\Controllers\Backend\NewsPostController;
use App\Http\Controllers\Backend\BannerController;
use App\Http\Controllers\Backend\ThanaController;
use App\Http\Controllers\Backend\PhotoGalleryController;
use App\Http\Controllers\Backend\VideoGalleryController;
use App\Http\Controllers\Backend\SeoSettingController;
use App\Http\Controllers\Backend\RoleController;
use App\Http\Controllers\Backend\PollController;

use App\Http\Controllers\Backend\SalatTimeController;
  
use Illuminate\Support\Facades\Artisan;

Route::get('/clear-cache', function () {
   Artisan::call('cache:clear');
   Artisan::call('route:clear');
   Artisan::call('config:cache');
   Artisan::call('view:clear');

   return "Cache cleared successfully";
});

// Route::get('/', function () {
//     return view('welcome');
// });



Route::get('/single-gallery-image/{id}', [IndexController::class, 'singleGalleryImage'])->name('single.gallery.image');
Route::get('/all-gallery-image', [IndexController::class, 'allGalleryImage'])->name('all.gallery.image');

Route::get('/all-videos', [IndexController::class, 'allVideos'])->name('all.videos');

Route::get('/converter', [IndexController::class, 'converter'])->name('converter');

Route::get('/login', [IndexController::class, 'login']);



Route::get('/', [IndexController::class, 'Index'])->name('index');
Route::get('/videos', [IndexController::class, 'allVideo']);
Route::get('/latest-news', [IndexController::class, 'allLatestNews'])->name('latest.news');


Route::get('/active-users', [IndexController::class, 'activeUsers']);




Route::get('/show-poll', [PollController::class, 'showingPolling'])->name('poll.show');
Route::post('/poll/vote/{id}', [PollController::class, 'vote'])->name('poll.vote');
Route::get('/poll/result/{id}', [PollController::class, 'result'])->name('poll.result');






// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');


Route::middleware(['auth'])->group(function() {

Route::get('/dashboard', [UserController::class, 'UserDashboard'])->name('dashboard');

Route::post('/user/profile/store', [UserController::class, 'UserProfileStore'])->name('user.profile.store');

Route::get('/user/logout', [UserController::class, 'UserLogout'])->name('user.logout');

Route::get('/change/password', [UserController::class, 'ChangePassword'])->name('change.password');

Route::post('/user/change/password', [UserController::class, 'UserChangePassword'])->name('user.change.password');

}); // End User Middleware 

require __DIR__.'/auth.php';




Route::middleware(['auth','role:admin'])->group(function() {


Route::get('/admin/dashboard', [AdminController::class, 'AdminDashboard'])->name('admin.dashboard');

Route::get('/admin/logout', [AdminController::class, 'AdminLogout'])->name('admin.logout');

Route::get('/admin/profile', [AdminController::class, 'AdminProfile'])->name('admin.profile');

Route::post('/admin/profile/store', [AdminController::class, 'AdminProfileStore'])->name('admin.profile.store');

Route::get('/admin/change/password', [AdminController::class, 'AdminChangePassword'])->name('admin.change.password');

Route::post('/admin/update/password', [AdminController::class, 'AdminUpdatePassword'])->name('admin.update.password');

}); // End Admin Middleware 


Route::get('/admin/login', [AdminController::class, 'AdminLogin'])->middleware(RedirectIfAuthenticated::class)->name('admin.login');

Route::get('/admin/logout/page', [AdminController::class, 'AdminLogoutPage'])->name('admin.logout.page'); 




Route::middleware(['auth','role:admin'])->group(function() {

// Category all Route
Route::controller(CategoryController::class)->group(function(){

    Route::get('/all/category','AllCategory')->name('all.category');
    Route::get('/add/category','AddCategory')->name('add.category');
    Route::post('/store/category','StoreCategory')->name('category.store');
    Route::get('/edit/category/{id}','EditCategory')->name('edit.category');
    Route::post('/update/category','UpdateCategory')->name('category.update');
    Route::get('/delete/category/{id}','DeleteCategory')->name('delete.category');

});


// SubCategory all Route
Route::controller(CategoryController::class)->group(function(){

    Route::get('/all/subcategory','AllSubCategory')->name('all.subcategory');
    Route::get('/add/subcategory','AddSubCategory')->name('add.subcategory');
    Route::post('/store/subcategory','StoreSubCategory')->name('subcategory.store');
    Route::get('/edit/subcategory/{id}','EditSubCategory')->name('edit.subcategory');
    Route::post('/update/subcategory','UpdateSubCategory')->name('subcategory.updated');
    Route::get('/delete/subcategory/{id}','DeleteSubCategory')->name('delete.subcategory');

     Route::get('/subcategory/ajax/{category_id}','GetSubCategory');

});
// District all Route
Route::controller(DistrictController::class)->group(function(){

    Route::get('/all/district','AllDistrict')->name('all.district');
    Route::get('/add/district','AddDistrict')->name('add.district');
    Route::post('/store/district','StoreDistrict')->name('district.store');
    Route::get('/edit/district/{id}','EditDistrict')->name('edit.district');
    Route::post('/update/district','UpdateDistrict')->name('district.updated');
    Route::get('/delete/district/{id}','DeleteDistrict')->name('delete.district');

    Route::get('/district/ajax/{district_id}','GetDistrict');
});
// District all Route
Route::controller(ThanaController::class)->group(function(){

    Route::get('/all/thana','AllThana')->name('all.thana');
    Route::get('/add/thana','AddThana')->name('add.thana');
    Route::post('/store/thana','StoreThana')->name('thana.store');
    Route::get('/edit/thana/{id}','EditThana')->name('edit.thana');
    Route::post('/update/thana','UpdateThana')->name('thana.updated');
    Route::get('/delete/thana/{id}','DeleteThana')->name('delete.thana');

    Route::get('/thana/ajax/{category_id}','GetThana');
    
    
    // Upozila thana route
    
    
    Route::get('/all/upozila-thana','AllUpozilaThana')->name('all.upozila.thana');
    Route::get('/add/upozila-thana','AddUpozilaThana')->name('add.upozila.thana');
    Route::post('/store/upozila-thana','StoreUpozilaThana')->name('upozila.thana.store');
    Route::get('/edit/upozila-thana/{id}','editUpozilaThana')->name('edit.upozila.thana');
    Route::post('/update/upozila-thana','updateUpozilaThana')->name('upozila.thana.update');
    
    
    Route::get('/upozila/thana/ajax/{id}','GetUpozilaThana');
    
    
    
    
});








// Admin User all Route
Route::controller(AdminController::class)->group(function(){

    Route::get('/all/admin','AllAdmin')->name('all.admin');
    Route::get('/add/admin','AddAdmin')->name('add.admin');
    Route::post('/store/admin','StoreAdmin')->name('admin.store');
    Route::get('/edit/admin/{id}','EditAdmin')->name('edit.admin');
    Route::post('/update/admin','UpdateAdmin')->name('admin.update');
    Route::get('/delete/admin/{id}','DeleteAdmin')->name('delete.admin');

    Route::get('/inactive/admin/user/{id}','InactiveAdminUser')->name('inactive.admin.user');

    Route::get('/active/admin/user/{id}','ActiveAdminUser')->name('active.admin.user');

});



// News Post all Route
Route::controller(NewsPostController::class)->group(function(){

    Route::get('/all/news/post','AllNewsPost')->name('all.news.post');
    Route::get('/add/news/post','AddNewsPost')->name('add.news.post');

    Route::post('/store/news/post','StoreNewsPost')->name('store.news.post');
    Route::get('/edit/news/post/{id}','EditNewsPost')->name('edit.news.post');
    Route::post('/update/news/post','UpdateNewsPost')->name('update.news.post');
    Route::get('/delete/news/post/{id}','DeleteNewsPost')->name('delete.news.post');

    Route::get('/inactive/news/post/{id}','InactiveNewsPost')->name('inactive.news.post');
    Route::get('/active/news/post/{id}','ActiveNewsPost')->name('active.news.post');
     
    Route::get('/all/draft/news/post','AllDraftNewsPost')->name('all.draft.news.post');
     
    Route::get('/delete/news-pdf/{id}','DeletePdfNewsPost')->name('delete.pdf.news.post');
      
    Route::post('/news/update-order', 'UpdateNewsOrder')->name('news.update.order');
    
    Route::get('/news/top-nine', 'NewsTopNine')->name('news.top.nine');
    
    Route::get('/top-sixteen-news', 'NewsTest')->name('news.test');
     
    Route::get('/all/scheduled/news/post','AllScheduledNewsPost')->name('all.scheduled.news.post');

});



// Banner all Route
Route::controller(BannerController::class)->group(function(){

    Route::get('/all/banners','AllBanners')->name('all.banners');
    Route::post('/update/banners','UpdateBanners')->name('update.banners');
   

});


// Salat Time Route
Route::controller(SalatTimeController::class)->group(function(){

    Route::get('/salat-times','salatTimes')->name('salat.time');
    Route::post('/update/salat-times','UpdateSalatTimes')->name('update.salat.time');
   

});


Route::controller(PollController::class)->group(function(){
    
        Route::get('/all-polls','allPolls')->name('all.polls');
        Route::get('/create-poll','createPoll')->name('create.poll');
        Route::post('/store-poll','storePoll')->name('poll.store');
        Route::get('/edit-poll/{id}','editPoll')->name('edit.poll');
        Route::post('/update/poll','updatePoll')->name('poll.update');
        Route::get('/delete/poll/{id}','deletePoll')->name('delete.poll');
     
    });




// PhotoGallery all Route
Route::controller(PhotoGalleryController::class)->group(function(){

    Route::get('/all/photo/gallery','AllPhotoGallery')->name('all.photo.gallery');
    Route::get('/add/photo/gallery','AddPhotoGallery')->name('add.photo.gallery');
    Route::post('/store/photo/gallery','StorePhotoGallery')->name('store.photo.gallery');

    Route::get('/edit/photo/gallery/{id}','EditPhotoGallery')->name('edit.photo.gallery');

    Route::post('/update/photo/gallery','UpdatePhotoGallery')->name('update.photo.gallery');

    Route::get('/delete/photo/gallery/{id}','DeletePhotoGallery')->name('delete.photo.gallery');
    
    Route::get('/media-photos','AllMediaPhotos')->name('media.photo');
     
   

});



// Video Gallery all Route
Route::controller(VideoGalleryController::class)->group(function(){

    Route::get('/all/video/gallery','AllVideoGallery')->name('all.video.gallery'); 

    Route::get('/add/video/gallery','AddVideoGallery')->name('add.video.gallery');

    Route::post('/store/video/gallery','StoreVideoGallery')->name('store.video.gallery');

     Route::get('/edit/video/gallery/{id}','EditVideoGallery')->name('edit.video.gallery');

     Route::post('/update/video/gallery','UpdateVideoGallery')->name('update.video.gallery');

     Route::get('/delete/video/gallery/{id}','DeleteVideoGallery')->name('delete.video.gallery');

     Route::get('/update/live/tv','UpdateLiveTv')->name('update.live.tv');
     Route::post('/update/live','UpdateLiveData')->name('update.live');

});



// Review all Route
Route::controller(ReviewController::class)->group(function(){

    Route::get('/pending/review','PendingReview')->name('pending.review');
    Route::get('/review/approve/{id}','ReviewApprove')->name('review.approve');
    Route::get('/approve/review','ApproveReview')->name('approve.review'); 
    Route::get('/delete/review/{id}','DeleteReview')->name('delete.review');
 
});


// Review all Route
Route::controller(SeoSettingController::class)->group(function(){

    Route::get('/seo/setting','SeoSiteSetting')->name('seo.setting');
    Route::post('/update/seo/setting','UpdateSeoSetting')->name('update.seo.setting');
 
});


// Permission all Route
Route::controller(RoleController::class)->group(function(){

    Route::get('/all/permission','AllPermission')->name('all.permission');
    Route::get('/add/permission','AddPermission')->name('add.permission');
    Route::post('/store/permission','StorePermission')->name('permission.store');
    Route::get('/edit/permission/{id}','EditPermission')->name('edit.permission');
    Route::post('/update/permission','UpdatePermission')->name('permission.update');
    Route::get('/delete/permission/{id}','DeletePermission')->name('delete.permission');
 
});


// Roles all Route
Route::controller(RoleController::class)->group(function(){

    Route::get('/all/roles','AllRoles')->name('all.roles');
    Route::get('/add/roles','AddRoles')->name('add.roles');
    Route::post('/store/roles','StoreRoles')->name('roles.store');
    Route::get('/edit/roles/{id}','EditRoles')->name('edit.roles');
    Route::post('/update/roles','UpdateRoles')->name('roles.update');
    Route::get('/delete/roles/{id}','DeleteRoles')->name('delete.roles');

    Route::get('/add/roles/permission','AddRolesPermission')->name('add.roles.permission');

    Route::post('/role/permission/store','RolePermisssionStore')->name('role.permission.store');

     Route::get('/all/roles/permission','AllRolesPermission')->name('all.roles.permission');

     Route::get('/admin/edit/roles/{id}','AdminEditRoles')->name('admin.edit.roles');

Route::get('/admin/delete/roles/{id}','AdminDeleteRoles')->name('admin.delete.roles');


     Route::post('/role/permission/update/{id}','RolePermissionUpdate')->name('role.permission.update');
 
});





 }); // End Admin Middleware 


/// Access for All 
Route::get('/news/details/{id}/{slug}', [IndexController::class, 'NewsDetails'])->name('newsDetails');
Route::get('/news/details/{id}', [IndexController::class, 'NewsDetailsOne'])->name('newsDetailsOne');

Route::get('/news/category/{id}/{slug}', [IndexController::class, 'CatWiseNews']);
Route::get('/news/subcategory/{id}/{slug}', [IndexController::class, 'SubCatWiseNews']);
Route::get('/news/district/{id}/{slug}', [IndexController::class, 'DistrictWiseNews']);
Route::get('/news/thana/{id}/{slug}', [IndexController::class, 'ThanaWiseNews']);

Route::get('/lang/change', [IndexController::class, 'Change'])->name('changeLang');

Route::post('/search', [IndexController::class, 'SearchByDate'])->name('search-by-date');

Route::post('/news', [IndexController::class, 'NewsSearch'])->name('news.search');

Route::get('/news-by-area', [IndexController::class, 'NewsSearchByArea'])->name('news.search.area');

Route::get('/reporter/{id}', [IndexController::class, 'ReporterNews'])->name('reporter.all.news');

Route::post('/store/review', [ReviewController::class, 'StoreReview'])->name('store.review');


Route::get('/news/subcategory', [IndexController::class, 'SubCatWiseNewsAll'])->name('sompadok.news');


/// End Access for All 

